function applyRules(rules, navigator, data) {
    const { userAgent } = navigator !== null && navigator !== void 0 ? navigator : {};
    if (typeof userAgent !== 'string' || userAgent.trim() === '') {
        return data;
    }
    for (const rule of rules){
        const patterns = rule.slice(0, -1);
        const parser = rule[rule.length - 1];
        let match = null;
        for (const pattern of patterns){
            match = userAgent.match(pattern);
            if (match !== null) {
                Object.assign(data, parser(match, navigator, data));
                break;
            }
        }
        if (match !== null) break;
    }
    return data;
}

export { applyRules };
