function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _object_spread(target) {
    for(var i = 1; i < arguments.length; i++){
        var source = arguments[i] != null ? arguments[i] : {};
        var ownKeys = Object.keys(source);
        if (typeof Object.getOwnPropertySymbols === "function") {
            ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function(sym) {
                return Object.getOwnPropertyDescriptor(source, sym).enumerable;
            }));
        }
        ownKeys.forEach(function(key) {
            _define_property(target, key, source[key]);
        });
    }
    return target;
}
function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);
        if (enumerableOnly) {
            symbols = symbols.filter(function(sym) {
                return Object.getOwnPropertyDescriptor(object, sym).enumerable;
            });
        }
        keys.push.apply(keys, symbols);
    }
    return keys;
}
function _object_spread_props(target, source) {
    source = source != null ? source : {};
    if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
        ownKeys(Object(source)).forEach(function(key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
    }
    return target;
}
function flagsExtension(descriptor) {
    let osName = descriptor.os.name;
    const isAndroid = descriptor.os.name === 'android';
    let isMacOS = descriptor.os.name === 'macos';
    let isIOS = descriptor.os.name === 'ios';
    var _descriptor_navigator_maxTouchPoints;
    /**
   * Newer iPads will identify as macOS in the UserAgent string but can still be differentiated by
   * inspecting `maxTouchPoints`. The macOS and iOS values need to be reset when detected.
   */ const isIPadOS = osName === 'ipados' || isIOS && /ipad/i.test(descriptor.ua) || isMacOS && ((_descriptor_navigator_maxTouchPoints = descriptor.navigator.maxTouchPoints) !== null && _descriptor_navigator_maxTouchPoints !== void 0 ? _descriptor_navigator_maxTouchPoints : 0) >= 2;
    if (isIPadOS) {
        osName = 'ipados';
        isIOS = false;
        isMacOS = false;
    }
    const browser = _object_spread_props(_object_spread({}, descriptor.browser), {
        isUnknown: descriptor.browser.name === 'unknown',
        isSafari: descriptor.browser.name === 'safari',
        isChrome: descriptor.browser.name === 'chrome',
        isFirefox: descriptor.browser.name === 'firefox',
        isEdge: descriptor.browser.name === 'edge',
        isWebView: descriptor.browser.name === 'webview',
        isOther: descriptor.browser.name === 'other',
        isMobile: descriptor.browser.mobile || isIOS || isIPadOS || isAndroid || false
    });
    const engine = _object_spread_props(_object_spread({}, descriptor.engine), {
        isUnknown: descriptor.engine.name === 'unknown',
        isWebKit: descriptor.engine.name === 'webkit',
        isBlink: descriptor.engine.name === 'blink',
        isGecko: descriptor.engine.name === 'gecko'
    });
    const os = _object_spread_props(_object_spread({}, descriptor.os), {
        name: osName,
        isUnknown: descriptor.os.name === 'unknown',
        isLinux: descriptor.os.name === 'linux',
        isWindows: descriptor.os.name === 'windows',
        isMacOS,
        isAndroid,
        isIOS,
        isIPadOS
    });
    return _object_spread_props(_object_spread({}, descriptor), {
        extensions: [
            ...descriptor.extensions,
            'flags'
        ],
        browser,
        os,
        engine
    });
}

export { flagsExtension };
