import { eq, gt, gte, lt, lte } from '../version.js';

function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _object_spread(target) {
    for(var i = 1; i < arguments.length; i++){
        var source = arguments[i] != null ? arguments[i] : {};
        var ownKeys = Object.keys(source);
        if (typeof Object.getOwnPropertySymbols === "function") {
            ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function(sym) {
                return Object.getOwnPropertyDescriptor(source, sym).enumerable;
            }));
        }
        ownKeys.forEach(function(key) {
            _define_property(target, key, source[key]);
        });
    }
    return target;
}
function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);
        if (enumerableOnly) {
            symbols = symbols.filter(function(sym) {
                return Object.getOwnPropertyDescriptor(object, sym).enumerable;
            });
        }
        keys.push.apply(keys, symbols);
    }
    return keys;
}
function _object_spread_props(target, source) {
    source = source != null ? source : {};
    if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
        ownKeys(Object(source)).forEach(function(key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
    }
    return target;
}
function compareExtension(descriptor) {
    function makeComparable(data) {
        var _data_major, _data_minor, _data_patch;
        const version = {
            major: (_data_major = data.major) !== null && _data_major !== void 0 ? _data_major : 0,
            minor: (_data_minor = data.minor) !== null && _data_minor !== void 0 ? _data_minor : 0,
            patch: (_data_patch = data.patch) !== null && _data_patch !== void 0 ? _data_patch : 0
        };
        return _object_spread_props(_object_spread({}, data), {
            eq: (value)=>eq(version, value),
            gt: (value)=>gt(version, value),
            gte: (value)=>gte(version, value),
            lt: (value)=>lt(version, value),
            lte: (value)=>lte(version, value),
            is: (value)=>data.name === value || data.variant === value
        });
    }
    return _object_spread_props(_object_spread({}, descriptor), {
        extensions: [
            ...descriptor.extensions,
            'compare'
        ],
        browser: makeComparable(descriptor.browser),
        engine: makeComparable(descriptor.engine),
        os: makeComparable(descriptor.os)
    });
}

export { compareExtension };
