"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JetNetworkFetch = void 0;
const optional_1 = require("@jet/environment/types/optional");
class JetNetworkFetch {
    async fetch(request) {
        var _a, _b, _c;
        if (optional_1.isNothing(process === null || process === void 0 ? void 0 : process.env.MEDIA_API_TOKEN)) {
            return await Promise.reject(new Error("process.env.MEDIA_API_TOKEN must be specified"));
        }
        const headers = {
            ...((_a = request.headers) !== null && _a !== void 0 ? _a : {}),
            authorization: `Bearer ${process === null || process === void 0 ? void 0 : process.env.MEDIA_API_TOKEN}`,
        };
        const response = await fetch(request.url, {
            body: request.body,
            method: (_b = request.method) !== null && _b !== void 0 ? _b : undefined,
            cache: (_c = request.cache) !== null && _c !== void 0 ? _c : undefined,
            headers: headers,
        });
        return {
            ok: response.ok,
            headers: Array.from(response.headers.keys()).reduce((previous, key) => {
                const value = response.headers.get(key);
                if (optional_1.isSome(value)) {
                    previous[key] = value;
                }
                return previous;
            }, {}),
            redirected: response.redirected,
            status: response.status,
            statusText: response.statusText,
            url: response.url,
            body: await response.text(),
            metrics: [],
        };
    }
}
exports.JetNetworkFetch = JetNetworkFetch;
