"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpiringValue = void 0;
/**
 * A class that wraps some value that expires in some future time.
 */
class ExpiringValue {
    constructor(value, maxAge) {
        this._value = value;
        this._maxAge = maxAge;
    }
    /// Whether or not value is valid (not expired).
    isValid() {
        return Date.now() < this._maxAge;
    }
    /** Access the expiring value, returning null if it is expired. */
    get value() {
        return this.isValid() ? this._value : null;
    }
}
exports.ExpiringValue = ExpiringValue;
//# sourceMappingURL=expiring-value.js.map