"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.flatMapOptional = exports.mapOptional = exports.unsafeUnwrapOptional = exports.unwrapOptional = exports.isSome = exports.isNothing = exports.unsafeUninitialized = void 0;
/**
 * Bypass the protection provided by the `Optional` type
 * and pretend to produce a value of `Some<T>` while
 * actually returning `Nothing`.
 */
function unsafeUninitialized() {
    return undefined;
}
exports.unsafeUninitialized = unsafeUninitialized;
/**
 * Test whether an optional does not contain a value.
 *
 * @param value - An optional value to test.
 */
function isNothing(value) {
    return value === undefined || value === null;
}
exports.isNothing = isNothing;
/**
 * Test whether an optional contains a value.
 * @param value - An optional value to test.
 */
function isSome(value) {
    return value !== undefined && value !== null;
}
exports.isSome = isSome;
/**
 * Unwrap the value contained in a given optional,
 * throwing an error if there is no value.
 *
 * @param value - A value to unwrap.
 */
function unwrapOptional(value) {
    if (isNothing(value)) {
        throw new ReferenceError();
    }
    return value;
}
exports.unwrapOptional = unwrapOptional;
/**
 * Unwrap the value contained in a given optional
 * without checking if the value exists.
 *
 * @param value - A value to unwrap.
 */
function unsafeUnwrapOptional(value) {
    return value;
}
exports.unsafeUnwrapOptional = unsafeUnwrapOptional;
function mapOptional(value, body) {
    if (isSome(value)) {
        return body(value);
    }
    else {
        return value;
    }
}
exports.mapOptional = mapOptional;
function flatMapOptional(value, body) {
    if (isSome(value)) {
        return body(value);
    }
    else {
        return value;
    }
}
exports.flatMapOptional = flatMapOptional;
//# sourceMappingURL=optional.js.map