"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.notInstrumented = exports.PageInvocationPoint = exports.EMPTY_LINTED_METRICS_EVENT = void 0;
/**
 * An empty linted metrics event.
 *
 * The empty events should be skipped from recording
 * by metrics event recorders.
 */
exports.EMPTY_LINTED_METRICS_EVENT = {
    fields: {},
    issues: [],
};
var PageInvocationPoint;
(function (PageInvocationPoint) {
    PageInvocationPoint["pageEnter"] = "pageEnter";
    PageInvocationPoint["pageExit"] = "pageExit";
    PageInvocationPoint["appExit"] = "appExit";
    PageInvocationPoint["appEnter"] = "appEnter";
    PageInvocationPoint["backButton"] = "backButton";
})(PageInvocationPoint = exports.PageInvocationPoint || (exports.PageInvocationPoint = {}));
/**
 * Returns an empty metrics instance of the specified metrics type.
 * @param metricsType - Type of the metrics data to return.
 *
 * @deprecated Do not use, all metrics events should be instrumented.
 */
function notInstrumented(metricsType) {
    switch (metricsType) {
        case 0 /* NotInstrumentedMetricsType.ActionMetrics */:
            return {
                data: [],
                custom: {},
            };
        case 1 /* NotInstrumentedMetricsType.FetchTimingMetrics */:
            return {};
        case 2 /* NotInstrumentedMetricsType.PageMetrics */:
            return {
                instructions: [],
                custom: {},
            };
        case 3 /* NotInstrumentedMetricsType.ImpressionMetrics */:
            return {
                id: {
                    id: "",
                    impressionIndex: -1,
                },
                fields: {},
                custom: {},
            };
        default:
            return {};
    }
}
exports.notInstrumented = notInstrumented;
// endregion
//# sourceMappingURL=metrics.js.map