"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.exportBootstrap = void 0;
const jet_proxy_1 = require("../dependencies/jet-proxy");
function exportBootstrap(bootstrap) {
    if (typeof $exportBootstrap !== "undefined") {
        /* Wraps the given bootstrap function to perform custom bootstrap behavior such
        as supporting lazy dependencies. */
        const customBootstrap = (service) => {
            proxyLazyDependencies(service);
            return bootstrap(service);
        };
        $exportBootstrap(customBootstrap);
    }
}
exports.exportBootstrap = exportBootstrap;
// We put has_lazy_support on the global object so native can check that the Jet runtime has lazy support.
globalThis["has_lazy_support"] = true;
// Installs proxies for lazy dependencies so we can create objects only as needed.
function proxyLazyDependencies(service) {
    const lazyDependencyNames = service.$lazyDependencyNames;
    const lazyDependencyNamesSet = new Set(lazyDependencyNames !== null && lazyDependencyNames !== void 0 ? lazyDependencyNames : []);
    const lazyGlobalNames = globalThis.$lazyGlobalNames;
    const lazyGlobalNamesSet = new Set(lazyGlobalNames !== null && lazyGlobalNames !== void 0 ? lazyGlobalNames : []);
    /* We take the union of lazy globals and lazy dependencies. For each lazy dependency name,
    we will make one proxy. We must avoid creating more than one proxy for a given name.
    For instance, if the name is present in the lazy dependencies and lazy globals, we do
    not want to create two proxies. Doing so would cause multiple object instances to be created
    natively for use in JS (one instance in the dependency object,
    another instance in the global object), leading to potential bugs. */
    const uniqueLazyNames = new Set([...lazyDependencyNamesSet, ...lazyGlobalNamesSet]);
    const proxyMap = new Map();
    const lazyProvider = globalThis.$lazyProvider;
    for (const lazyName of uniqueLazyNames) {
        // Create one proxy per name present in either lazy globals or lazy dependencies.
        proxyMap.set(lazyName, jet_proxy_1.LazyProxyFactory.makeProxy(lazyName, lazyProvider));
    }
    // For each lazy dependency name, put the proxy on the dependency (service) object under the given name.
    for (const lazyDependencyName of lazyDependencyNamesSet) {
        service[lazyDependencyName] = proxyMap.get(lazyDependencyName);
    }
    // For each lazy global name, put the proxy on the global object under the given name.
    for (const lazyGlobalName of lazyGlobalNamesSet) {
        globalThis[lazyGlobalName] = proxyMap.get(lazyGlobalName);
    }
}
//# sourceMappingURL=bootstrap.js.map