"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Router = void 0;
const optional_1 = require("../types/optional");
const routing_components_1 = require("./routing-components");
/**
 * Converts a URL into an intent. This intent can then be dispatched using a dispatcher
 * (see `IntentDispatcher`).
 *
 * Routes can be registered using either the `associate` function or using route providers
 * (see `RouteProvider`).
 */
class Router {
    constructor() {
        this.router = new routing_components_1.UrlRouter();
    }
    /**
     * Registers a new implementation that will be invoked when any of the provided
     * URL rules are matched.
     * @param urlRules - The rules that will be registered.
     * @param implementation - The implementation to invoke if any of the rules are matched.
     */
    associate(urlRules, implementation) {
        this.router.associate(urlRules, implementation);
    }
    /**
     * Uses the registered routing rules to produce an intent for the provided URL.
     * @param url - The URL to route;
     */
    intentFor(url) {
        const routerResult = this.router.routedObjectForUrl(url);
        if ((0, optional_1.isSome)(routerResult.object) && (0, optional_1.isSome)(routerResult.parameters)) {
            return routerResult.object(routerResult.normalizedUrl, routerResult.parameters, routerResult);
        }
        return null;
    }
}
exports.Router = Router;
//# sourceMappingURL=router.js.map