"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerRoutesProvider = exports.isRouteProvider = void 0;
const optional_1 = require("../types/optional");
/**
 * Checks if an object conforms to `RouteProvider`.
 * @remarks This function does not perform any checking for the generic types.
 * @param provider - The object that may be a route provider.
 */
function isRouteProvider(provider) {
    if (typeof provider !== "object") {
        return false;
    }
    return (0, optional_1.isSome)(provider === null || provider === void 0 ? void 0 : provider["routes"]);
}
exports.isRouteProvider = isRouteProvider;
/**
 * Registers all routes provided by a `RouteProvider` to a router.
 * @param router - The router to register routes on.
 * @param provider - The route provider to get the routes from.
 * @param objectGraph - An object graph for dependency injection.
 */
function registerRoutesProvider(router, provider, objectGraph) {
    provider.routes(objectGraph).forEach((definition) => {
        router.associate(definition.rules, definition.handler);
    });
}
exports.registerRoutesProvider = registerRoutesProvider;
//# sourceMappingURL=route-provider.js.map