"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeCompoundAction = exports.isCompoundAction = void 0;
/**
 * Custom type guard to determine if an action is a CompoundAction.
 */
function isCompoundAction(action) {
    return (action === null || action === void 0 ? void 0 : action.$kind) === "compoundAction";
}
exports.isCompoundAction = isCompoundAction;
/**
 * Helper that returns a CompoundAction, given an ActionMetrics and ActionModel[] of subactions.
 */
function makeCompoundAction(actionMetrics, subactions) {
    return {
        $kind: "compoundAction",
        subactions,
        actionMetrics,
    };
}
exports.makeCompoundAction = makeCompoundAction;
//# sourceMappingURL=compound-action.js.map