"use strict";
/**
 * Number related helper functions for metrics.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.reduceSignificantDigits = void 0;
/**
 * Reduce significant figures of `value` by `significantDigits`.
 * @param value - Value to reduce precision of.
 * @param significantDigits - Number of significant digits to reduce precision by.
 *
 * Examples:
 * value = 123.5, significantDigits = 0, result = 120 (no significant digit reduced)
 * value = 123.5, significantDigits = 1, result = 120 (1 significant digit reduced)
 * value = 123.5, significantDigits = 2, result = 100 (2 significant digit reduced)
 */
function reduceSignificantDigits(value, significantDigits) {
    const roundFactor = Math.pow(10.0, significantDigits);
    const roundingFunction = value > 0.0 ? Math.floor : Math.ceil;
    return roundingFunction(value / roundFactor) * roundFactor;
}
exports.reduceSignificantDigits = reduceSignificantDigits;
//# sourceMappingURL=numerics.js.map