"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cookieValueForKey = exports.cookiesOf = void 0;
const optional_1 = require("../types/optional");
/**
 * Iterate the cookies contained in a string.
 *
 * @param cookie - A string containing zero or more cookies.
 */
function* cookiesOf(cookie) {
    if ((0, optional_1.isNothing)(cookie)) {
        return;
    }
    const rawEntries = cookie.split(";");
    for (const rawEntry of rawEntries) {
        const keyEndIndex = rawEntry.indexOf("=");
        if (keyEndIndex === -1) {
            // If there's no splitter, treat the whole raw
            // entry as the key and provide an empty value.
            const key = decodeURIComponent(rawEntry).trim();
            yield { key, value: "" };
        }
        else {
            const key = decodeURIComponent(rawEntry.substring(0, keyEndIndex)).trim();
            const value = decodeURIComponent(rawEntry.substring(keyEndIndex + 1)).trim();
            yield { key, value };
        }
    }
}
exports.cookiesOf = cookiesOf;
/**
 * Returns value of the cookie with the given key or `null` if there's no such cookie.
 *
 * @param cookies - Cookies.
 * @param key - The key to return cookie value for.
 */
function cookieValueForKey(cookies, key) {
    for (const cookie of cookies) {
        if (cookie.key === key) {
            return cookie.value;
        }
    }
    return null;
}
exports.cookieValueForKey = cookieValueForKey;
//# sourceMappingURL=cookies.js.map