"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isBaseActionProvider = void 0;
const optional_1 = require("../../types/optional");
/**
 * Checks if an object conforms to `BaseActionProvider`.
 * @remarks
 * This function does not perform any checking for the generic types.
 * @param provider - The object that may be an action provider.
 */
function isBaseActionProvider(provider) {
    if (typeof provider !== "object") {
        return false;
    }
    return (0, optional_1.isSome)(provider === null || provider === void 0 ? void 0 : provider["actionFor"]);
}
exports.isBaseActionProvider = isBaseActionProvider;
//# sourceMappingURL=action-provider.js.map