"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.inject = exports.ObjectGraph = void 0;
const optional_1 = require("../types/optional");
/* eslint-disable no-underscore-dangle */
class ObjectGraph {
    constructor(name) {
        this._members = {};
        this.name = name;
    }
    adding(type, member) {
        const clone = this.clone();
        clone._members[type.name] = member;
        return clone;
    }
    removing(type) {
        const clone = this.clone();
        // eslint-disable-next-line @typescript-eslint/no-dynamic-delete
        delete clone._members[type.name];
        return clone;
    }
    optional(type) {
        return this._members[type.name];
    }
    required(type) {
        const member = this._members[type.name];
        if ((0, optional_1.isNothing)(member)) {
            // eslint-disable-next-line @typescript-eslint/require-array-sort-compare
            const candidates = Object.keys(this._members).sort().join(", ");
            throw new Error(`No member with type ${type.name} found in ${this.name}. Candidates ${candidates}`);
        }
        return member;
    }
    clone() {
        const ctor = this.constructor;
        // eslint-disable-next-line new-cap
        const clone = new ctor(this.name);
        for (const [type, member] of Object.entries(this._members)) {
            clone._members[type] = member;
        }
        return clone;
    }
}
exports.ObjectGraph = ObjectGraph;
function inject(type, objectGraph) {
    return objectGraph.required(type);
}
exports.inject = inject;
//# sourceMappingURL=object-graph.js.map