"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProxiedNetwork = void 0;
/**
 * `Network` object designed to wrap the bridged native network object,
 * which automatically includes page intent instrumentation data in the fetch request.
 */
class ProxiedNetwork {
    constructor(original, pageIntentInstrumentation) {
        this.original = original;
        this.pageIntentInstrumentation = pageIntentInstrumentation;
    }
    async fetch(request) {
        request["$pageIntentInstrumentation"] = this.pageIntentInstrumentation;
        return await this.original.fetch(request);
    }
}
exports.ProxiedNetwork = ProxiedNetwork;
//# sourceMappingURL=net.js.map