"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PageMetricsFieldsProvider = void 0;
const optional_1 = require("@jet/environment/types/optional");
class PageMetricsFieldsProvider {
    addMetricsFields(builder, context) {
        const pageFields = context.pageFields;
        if (optional_1.isNothing(pageFields)) {
            // No page fields
            return;
        }
        for (const field in pageFields) {
            if (Object.prototype.hasOwnProperty.call(pageFields, field)) {
                builder.addValue(pageFields[field], field);
            }
        }
    }
}
exports.PageMetricsFieldsProvider = PageMetricsFieldsProvider;
