import { makeMetatype } from "@jet/environment/util/metatype";
import { Wrapper } from "./wrapper";
export class HostWrapper extends Wrapper {
    get clientIdentifier() {
        return this.implementation.clientIdentifier;
    }
    get clientVersion() {
        return this.implementation.clientVersion;
    }
    get deviceLocalizedModel() {
        return this.implementation.deviceLocalizedModel;
    }
    get deviceModel() {
        return this.implementation.deviceModel;
    }
    get deviceModelFamily() {
        return this.implementation.deviceModelFamily;
    }
    get devicePhysicalModel() {
        return this.implementation.devicePhysicalModel;
    }
    get deviceMarketingFamilyName() {
        return this.implementation.deviceMarketingFamilyName;
    }
    get osBuild() {
        return this.implementation.osBuild;
    }
    get platform() {
        return this.implementation.platform;
    }
    isOSAtLeast(majorVersion, minorVersion, patchVersion) {
        return this.implementation.isOSAtLeast(majorVersion, minorVersion, patchVersion);
    }
    /** Returns `true` for iOS host. */
    get isiOS() {
        return this.platform === "iOS";
    }
    /** Returns `true` for macOS host. */
    get isMac() {
        return this.platform === "macOS";
    }
    /** Returns `true` for tvOS host. */
    get isTV() {
        return this.platform === "tvOS";
    }
    /** Returns `true` for watchOS host. */
    get isWatch() {
        return this.platform === "watchOS";
    }
    /** Returns `true` for web host. */
    get isWeb() {
        return this.platform === "web";
    }
    /** Returns `true` for Windows host. */
    get isWindows() {
        return this.platform === "Windows";
    }
    /** Returns `true` for visionOS host. */
    get isVision() {
        return this.platform === "xrOS";
    }
}
HostWrapper.type = makeMetatype("app-store:host-wrapper");
//# sourceMappingURL=host.js.map