/**
 * Created by Pete Hare on 2/7/17.
 */
import { makeMetatype } from "@jet/environment/util/metatype";
import { Size } from "../../api/models/base";
import * as serverData from "../json-parsing/server-data";
import { Wrapper } from "./wrapper";
// region API
/**
 * Client identifier for the App Store.
 */
export const appStoreIdentifier = "com.apple.AppStore" /* ClientIdentifier.AppStore */;
/**
 * Client identifier for the Bridge (Watch) store.
 */
export const watchIdentifier = "com.apple.AppStore.BridgeStoreExtension" /* ClientIdentifier.AppStore_BridgeStoreExtension */;
/**
 * Client identifier for the iMessages store.
 */
export const messagesIdentifier = "com.apple.MobileSMS" /* ClientIdentifier.MobileSMS */;
/**
 * Client identifier for the arcade app.
 */
export const arcadeIdentifier = "com.apple.Arcade" /* ClientIdentifier.Arcade */;
/**
 * Client identifier indicating ATV.
 */
export const tvIdentifier = "com.apple.TVAppStore" /* ClientIdentifier.TVAppStore */;
/**
 * Client identifier for the Arcade launch repair SubscribePageExtension (iOS).
 */
export const productPageExtensionIdentifier = "com.apple.AppStore.ProductPageExtension" /* ClientIdentifier.AppStore_ProductPageExtension */;
/**
 * Client identifier for the Arcade launch repair SubscribePageExtension (iOS).
 */
export const subscribePageExtensionIdentifier = "com.apple.AppStore.SubscribePageExtension" /* ClientIdentifier.AppStore_SubscribePageExtension */;
export class ClientWrapper extends Wrapper {
    get buildType() {
        return this.implementation.buildType;
    }
    // This is only supported in Luckier client builds from AppStoreJet 11.1.7 & GamesUI 2.1.5 onwards. Any previous
    // clients will return undefined.
    get buildVersion() {
        return this.implementation.buildVersion;
    }
    get deviceType() {
        return this.implementation.deviceType;
    }
    get guid() {
        return this.implementation.guid;
    }
    get isActivityAvailable() {
        return this.implementation.isActivityAvailable;
    }
    get isElectrocardiogramInstallationAllowed() {
        return this.implementation.isElectrocardiogramInstallationAllowed;
    }
    get isScandiumInstallationAllowed() {
        return this.implementation.isScandiumInstallationAllowed;
    }
    get isSidepackingEnabled() {
        return this.implementation.isSidepackingEnabled;
    }
    get isTinkerWatch() {
        return this.implementation.isTinkerWatch;
    }
    get screenCornerRadius() {
        return this.implementation.screenCornerRadius;
    }
    get screenSize() {
        return Size.fromNativeSize(this.implementation.screenSize);
    }
    get storefrontIdentifier() {
        return this.implementation.storefrontIdentifier;
    }
    get supportsHEIF() {
        return this.implementation.supportsHEIF;
    }
    get thinnedApplicationVariantIdentifier() {
        return this.implementation.thinnedApplicationVariantIdentifier;
    }
    get isMandrakeSupported() {
        return this.implementation.isMandrakeSupported;
    }
    get isCharonSupported() {
        return this.implementation.isCharonSupported;
    }
    get isIconArtworkCapable() {
        return this.implementation.isIconArtworkCapable;
    }
    get maxAppContentRating() {
        return this.implementation.maxAppContentRating;
    }
    get hostBundleId() {
        return this.implementation.hostBundleId;
    }
    isPairedSystemVersionAtLeast(version) {
        var _a, _b, _c;
        return (_c = (_b = (_a = this.implementation).isPairedSystemVersionAtLeast) === null || _b === void 0 ? void 0 : _b.call(_a, version)) !== null && _c !== void 0 ? _c : false;
    }
    deletableSystemAppCanBeInstalledOnWatchWithBundleID(bundleId) {
        return this.implementation.deletableSystemAppCanBeInstalledOnWatchWithBundleID(bundleId);
    }
    deviceHasCapabilities(capabilities) {
        return this.implementation.deviceHasCapabilities(capabilities);
    }
    deviceHasCapabilitiesIncludingCompatibilityCheckIsVisionOSCompatibleIOSApp(capabilities, supportsVisionOSCompatibleIOSBinary) {
        if (this.isPad && capabilities.includes("healthkit")) {
            // Workaround for: rdar://116905381 (J517/21C16: Unable to download AC Wellness even though App Store page says its compatible with my iPad)
            return false;
        }
        return this.implementation.deviceHasCapabilitiesIncludingCompatibilityCheckIsVisionOSCompatibleIOSApp(capabilities, supportsVisionOSCompatibleIOSBinary);
    }
    isActivePairedWatchSystemVersionAtLeastMajorVersionMinorVersionPatchVersion(majorVersion, minorVersion, patchVersion) {
        return this.implementation.isActivePairedWatchSystemVersionAtLeastMajorVersionMinorVersionPatchVersion(majorVersion, minorVersion, patchVersion);
    }
    canDevicePerformAppActionWithAppCapabilities(appAction, appCapabilities) {
        return this.implementation.canDevicePerformAppActionWithAppCapabilities(appAction, appCapabilities);
    }
    isAutomaticDownloadingEnabled() {
        return this.implementation.isAutomaticDownloadingEnabled();
    }
    isAuthorizedForUserNotifications() {
        return this.implementation.isAuthorizedForUserNotifications();
    }
    /**
     * Check whether the active paired device's OS is below a given version.
     */
    isActivePairedWatchSystemVersionBelow(version) {
        // We want to use isActivePairedWatchSystemVersionAtLeastMajorVersionMinorVersionPatchVersion
        // rather than isPairedSystemVersionAtLeast here, as the latter is only available from YukonB onwards
        const versionComponents = version.split(".");
        const majorVersion = serverData.asNumber(versionComponents[0]) || 0;
        const minorVersion = serverData.asNumber(versionComponents[1]) || 0;
        const patchVersion = serverData.asNumber(versionComponents[2]) || 0;
        return !this.implementation.isActivePairedWatchSystemVersionAtLeastMajorVersionMinorVersionPatchVersion(majorVersion, minorVersion, patchVersion);
    }
    /** Returns `true` for phone-factor iOS devices. */
    get isPhone() {
        return this.deviceType === "phone";
    }
    /** Returns `true` for pad-factor iOS devices. */
    get isPad() {
        return this.deviceType === "pad";
    }
    /**
     * Returns `true` for iOS devices.
     *
     * Note: this property might be replaced with a build-time macro in "production"
     */
    get isiOS() {
        return this.isPhone || this.isPad;
    }
    /**
     * Returns `true` for Mac devices

     * Note: this property might be replaced with a build-time macro in "production"
     */
    get isMac() {
        return this.deviceType === "mac";
    }
    /**
     * Returns `true` for TV devices.

     * Note: this property might be replaced with a build-time macro in "production"
     */
    get isTV() {
        return this.deviceType === "tv";
    }
    /**
     * Returns `true` for Watch devices.

     * Note: this property might be replaced with a build-time macro in "production"
     */
    get isWatch() {
        return this.deviceType === "watch";
    }
    /**
     * Returns `true` for Vision devices.
     *
     * Note: this property might be replaced with a build-time macro in "production"
     */
    get isVision() {
        return this.deviceType === "vision";
    }
    /**
     * Returns `true` for the Web
     *
     * Note: this property might be replaced with a build-time macro in "production"
     */
    get isWeb() {
        return this.deviceType === "web";
    }
    get isCompanionVisionApp() {
        return this.hostBundleId === "com.apple.visionproapp";
    }
    /** Returns the list of remote identifiers to download any purchases to. */
    get remoteDownloadIdentifiers() {
        return this.implementation.remoteDownloadIdentifiers;
    }
}
ClientWrapper.type = makeMetatype("app-store:client-wrapper");
// endregion
//# sourceMappingURL=client.js.map