/* eslint-disable @typescript-eslint/no-explicit-any */
/**
 * Created by km on 3/6/17.
 */
/**
 * Creates and returns a shallow copy of a given object.
 * @param object    The object to create a shallow copy of.
 * @returns The new copy of object.
 */
export function shallowCopyOf(object) {
    if (object === null || object === undefined) {
        return object;
    }
    const copy = Object.create(Object.getPrototypeOf(object));
    Object.assign(copy, object);
    return copy;
}
/**
 * Returns whether or not a given object is an instance of
 * a specified type, modifying the type of the object in
 * TypeScript's type system.
 *
 * Prefer this function to using `instanceof` directly as it
 * will retype the passed in object if the check succeeds.
 *
 * @param object The object whose nominal type will be checked.
 * @param type The metatype that `object` is expected to be an instance of.
 * @returns Whether object is an instance of type, updating the type of object accordingly.
 */
export function isTypeOf(object, type) {
    return object instanceof type;
}
//# sourceMappingURL=objects.js.map