import { isBaseActionProvider } from "@jet/environment/dispatching";
/**
 * Retrieve an {@linkcode ActionModel} for the given {@linkcode intent} through
 * any registered `IntentController`s that implement `ActionProvider`
 */
export function actionFor(intent, objectGraph, options = {}) {
    const resolvedController = objectGraph.dispatcher.controller(intent);
    if (isBaseActionProvider(resolvedController)) {
        return resolvedController.actionFor(intent, objectGraph, options);
    }
    return null;
}
//# sourceMappingURL=action-provider.js.map