/**
 * Copied from SKUIUrl these action types come in urls like scheme:/?action=[UrlAction]
 */
/* tslint:disable:variable-name */
export const Protocol = {
    /// Protocol used for internal app store routing
    internal: "x-as3-internal",
    /// Protocol used for routing HTTP URLs
    http: "http",
    /// Protocol used for routing standard HTTPS URLs
    https: "https",
    /// The protocol used for iTunes app urls
    itms: "itms",
    /// The protocol used for secure iTunes app urls
    itmss: "itmss",
    /// Protocol used to target the app store
    itmsAppss: "itms-appss",
    /// Protocol used to target the app store
    itmsApps: "itms-apps",
    /// Protocol used to target the messages app store
    itmsMessagess: "itms-messagess",
    /// Protocol used to target the messages app store
    itmsMessages: "itms-messages",
    /// Protocol used to target the watch app store
    itmsWatchs: "itms-watchs",
    /// Protocol used to target the watch app store
    itmsWatch: "itms-watch",
    /// Protocol used for internal file routing
    file: "file",
    /// Protocol used for referencing resources in the host app's bundles.
    resource: "resource",
    /// Protocol used to target the mac app store
    macappstore: "macappstore",
    /// Protocol used to target the mac app store
    macappstores: "macappstores",
    /// Legacy protocol used to target the tv app store,
    /// kept to maintain backwards compatibility.
    tvappstoreLegacy: "com.apple.tvappstore",
    /// Protocol used to target the tv app store
    tvappstore: "com.apple.TVAppStore",
    /// Protocol used to target Arcade
    arcade: "com.apple.Arcade",
    /// Protocol used to target StoreKitUI App Store service
    storeKitUIServiceAppStore: "appstore-ui",
};
export const Path = {
    // Path for loading a shelf
    shelf: "shelf",
    // Path for MZStore requests
    store: "WebObjects/MZStore.woa/wa",
    // Path for MZStoreElements requests
    storeElements: "WebObjects/MZStoreElements.woa/wa",
    // Path for performing a lookup
    lookup: "lookup",
    // Path for performing a docTypeLookup
    docTypeLookup: "docTypeLookup",
    // Path for performing an install sheet
    install: "install",
    // Path to the grouping page
    grouping: "viewGrouping",
    // Path to the artist page
    viewArtist: "viewArtist",
    // Path to the product page
    viewSoftware: "viewSoftware",
    // Path to the today page
    today: "today",
    // Path to the arcade main page
    arcade: "arcade",
    arcadeUpsellPreview: "arcadeUpsellPreview",
    // Path to Arcade See All
    arcadeSeeAllGames: "arcadeSeeAllGames",
    // Pagination path for Arcade See All
    arcadeSeeAllGamesLoadMore: "arcadeSeeAllGamesLoadMore",
    // Path to the genre page (which is a grouping page)
    genre: "genre",
    // Path to the genre page (which is a grouping page)
    viewGenre: "viewGenre",
    recommendationsSeeAll: "recommendationsSeeAll",
    // Path for a screenshots lookup.
    screenshots: "screenshots",
    // Path to a single room
    room: "viewRoom",
    // Path to a programmed multi-room
    multiRoom: "viewMultiRoom",
    // Path to the main top charts page
    charts: "charts",
    // Path to the product page
    product: "app",
    // Path to the game page
    game: "game",
    // Path to siri product page deep links on tvOS App Store.
    siri: "siri",
    // Path to the product page for an app bundle.
    productBundle: "app-bundle",
    // Path component for the developer page
    developer: "developer",
    artist: "artist",
    // Path component for the ratings shelf
    ratings: "ratings",
    // Path component for the reviews shelf
    reviews: "reviews",
    // Path to view reviews for MZStore
    viewReviews: "viewContentsUserReviews",
    // Path component for the personalized review shelf
    personalizedReviews: "personalizedReviews",
    // Path to editorial items (articles)
    article: "article",
    story: "story",
    editorialItem: "editorialItem",
    viewEditorialItem: "viewEditorialItem",
    todayCardPreview: "todayCardPreview",
    // Path component for MSO rooms
    mso: "mso",
    // Path for resetting the storefront
    resetAndRedirect: "resetAndRedirect",
    // Account
    account: "account",
    personalizationTransparency: "personalizationTransparency",
    // Path component for an href-driven route.
    href: "href",
    // Path component for the EULA.
    eula: "eula",
    // Path component for the EULA on tvOS.
    tvEula: "tv-eula",
    // Path component for the Privacy Policy on tvOS.
    privacyPolicy: "privacyPolicy",
    // Path component for the Safety and Compliance Page on tvOS.
    safetyCompliance: "safety-compliance",
    // Path component for recommendations
    appsForYou: "apps-for-you",
    // Path for the storeFront
    storeFront: "storeFront",
    // Path for the tab
    tab: "tab",
    // Path component for the search landing page.
    searchLandingPage: "searchLandingPage",
    // Path component for search trending content page.
    searchTrendingApps: "searchTrendingApps",
    // Path for showing product privacy detail page
    privacyDetail: "privacyDetail",
    // Path for showing product privacy definitions page
    privacyDefinitions: "privacyDefinitions",
    // Path for the report a problem link
    reportAProblem: "reportaproblem.apple.com/store",
    // Path for showing a game center player profile
    gameCenterProfile: "gameCenterProfile",
    // Path for showing the ODP page
    onDeviceRecommendations: "onDeviceRecommendations",
    // Path for editorial pages
    editorialPage: "editorialPage",
    // Path to acessibility details
    accessibilityDetails: "accessibilityDetails",
    // ----------------------
    // Debug
    // ----------------------
    test: "test",
    shelfTypes: "shelfTypes",
    groupingTest: "grouping",
    builtIn: "builtIn",
    shelfTextTest: "shelfText",
    shelfLockupsTest: "shelfLockups",
    shelfMiscTest: "shelfMisc",
    lockupTest: "lockupTest",
    articleTestArtwork: "articleArtworkTest",
    articleTestSingleAppIcon: "articleSingleAppIconTest",
    articleTestSingleAppIconHeroArt: "articleSingleAppIconHeroArtTest",
    articleTestBrandedApp: "articleBrandedAppTest",
    articleTestMultiAppTwo: "articleMultiAppTwoTest",
    articleTestMultiAppThree: "articleMultiAppThreeTest",
    articleTestGrid: "articleGridTest",
    articleTestInAppPurchase: "articleInAppPurchaseTest",
};
export const Host = {
    // Legacy Mac Software Update URL
    showUpdatesPage: "showUpdatesPage",
    // Legacy Deep Link Actions
    showAccountPage: "showAccountPage",
    showPurchasesPage: "showPurchasesPage",
    showSubscriptionsPage: "showSubscriptionsPage",
    // Legacy MAS Safari Extension Search
    searchExtensions: "searchExtensions",
    // Legacy search.itunes.apple.com redirected urls
    searchItunes: "search.itunes.apple.com",
    // Legacy itunes.apple.com redirected urls
    iTunes: "itunes.apple.com",
    // Urls allowing programming to preview programmed groupings
    storePreview: "storepreview.apple.com",
    // Urls allowing programming to preview programmed stories
    appsPreview: "preview.apps.apple.com",
    // Legacy product url for tvOS App Store
    product: "product",
    // Host for arcade subscribe page
    arcadeSubscribePage: "arcadeSubscribePage",
    // Host for an upsell that must necessarily go through our own Arcade subscribe page,
    // rather than through an AMS marketing item page.
    arcadeSubscribePageCustomContext: "arcadeSubscribePageCustomContext",
    // Host for arcade welcome page
    arcadeWelcomePage: "arcadeWelcomePage",
    // Host for Arcade See All page for standalone case.
    arcadeSeeAllPage: "arcadeSeeAllGames",
    // Host for the deep link from an Arcade app clip.
    appClipSubscribe: "appClipSubscribe",
    familyCircle: "familyCircle",
    // Host for showing spam blocking extensions
    spamBlockingExtensions: "spamBlockingExtensions",
    // Host for showing Safari extensions
    safariExtensions: "safariExtensions",
    // Host for app launch trampoline
    launchApp: "launchApp",
    // Host for SharePlay more deeplink
    sharePlayApps: "sharePlayApps",
    // Host for opening a deeplink at the end of Buddy
    buddyOnboarding: "buddyOnboarding",
    // Host for Arcade download (starter) pack page
    arcadeDownloadPackPage: "arcadeDownloadPack",
    // Host for showing settings page
    showSettingsPage: "showSettingsPage",
    // Host for showing settings page
    showHiddenPurchasesPage: "showHiddenPurchases",
};
/// The different preview hosts that require the media api preview endpoint
export const previewHosts = new Set([Host.storePreview, Host.appsPreview]);
export const Parameters = {
    // Generic ID
    id: "id",
    // Generic IDs
    ids: "ids",
    // Product variant ID for given `id`
    productVariantID: "ppid",
    // Country Code
    countryCode: "cc",
    // Language override
    language: "l",
    // Featured Content ID
    featuredContentId: "fcId",
    fetchData: "fetchData",
    isTodaySection: "isTodaySection",
    isTodayFeedPreview: "isTodayFeedPreview",
    // Genre
    genre: "genre",
    // Bundle Identifier
    bundleIdentifier: "bundleIdentifier",
    // BundleID
    bundleId: "bundleId",
    // Spotlight In-App Purchase Identifier
    offerName: "offerName",
    // Top Charts
    charts: "charts",
    ages: "ages",
    chart: "chart",
    types: "types",
    // v0 urls (used e.g. when redirected from MZContentLink URLs).
    v0: "v0",
    // Action urls
    action: "action",
    // Type parameter
    type: "type",
    context: "context",
    isArcade: "isArcade",
    isSubscribed: "isSubscribed",
    isTrialAvailable: "isTrialAvailable",
    isTrialEnrolled: "isTrialEnrolled",
    groupingFeaturedContentId: "groupingFeaturedContentId",
    editorialPageShelfType: "editorialPageShelfType",
    nativeGroupingShelfId: "nativeGroupingShelfId",
    isArcadeSeeAllGamesShelf: "isArcadeSeeAllGamesShelf",
    isGameCenterActivityFeedShelf: "isGameCenterActivityFeedShelf",
    isGameCenterPlayerShelf: "isGameCenterPlayerShelf",
    isGameCenterPlayerRibbonItem: "isGameCenterPlayerRibbonItem",
    isGameCenterAchievementsShelf: "isGameCenterAchievementsShelf",
    isGameCenterContinuePlayingShelf: "isGameCenterContinuePlayingShelf",
    isGameCenterPopularWithYourFriendsShelf: "isGameCenterPopularWithYourFriendsShelf",
    isGameCenterSuggestedFriendsShelf: "isGameCenterSuggestedFriendsShelf",
    isGameCenterReengagementShelf: "isGameCenterReengagementShelf",
    isOnDeviceRecommendationsShelf: "isOnDeviceRecommendationsShelf",
    isOnDeviceSearchHistoryShelf: "isOnDeviceSearchHistoryShelf",
    isSearchFocusHeaderShelf: "isSearchFocusHeaderShelf",
    isArcadeDownloadPackShelfPlaceholder: "isArcadeDownloadPackShelfPlaceholder",
    onDeviceRecommendationsUseCase: "onDeviceRecommendationsUseCase",
    onDevicePersonalizationUseCase: "onDevicePersonalizationUseCase",
    // Denotes that this url is coming from the purchases page.
    isPurchasesApp: "isPurchasesApp",
    // Used for single sign on, the parameter is passed from store kit
    isViewOnly: "isViewOnly",
    // Determines whether unlisted apps should be returned in the response.
    // Note that for direct lookups, MAPI allows the App Store to view unlisted
    // apps without this parameter, although they would like to eventually gate
    // the behavior behind this parameter.
    includeUnlistedApps: "includeUnlistedApps",
    enabled: "enabled",
    href: "href",
    recoMetrics: "recoMetrics",
    // Used on article urls when the TodayCard is showing fallback media
    showingFallbackMedia: "showingFallbackMedia",
    path: "path",
    useReleaseId: "useReleaseId",
    // The client identifier that should be used to display the item, regardless of host device.
    clientIdentifierOverride: "clientIdentifierOverride",
    // The message attached to the subscribe page, for ATB.
    subscribePageMessage: "message",
    // The ID for a specific editorial item, in the case of a subscribe page.
    editorialItem: "editorialItem",
    // The identifer for the ATB request.
    askToBuyId: "askToBuyId",
    // Indicates an ID, when the 'app' disambiguation is necessary.
    appId: "appId",
    // Whether the URL has been launched from a PPT (Purple Performance Test).
    isPPT: "isPPT",
    // How the shelf is sorted, represented by a value of `ArcadeSeeAllGamesPageSort`
    sort: "sort",
    // Featured Content ID
    grouping: "grouping",
    // Code Parameter, e.g. for Redeem code
    code: "code",
    // Parameter to include attribution on offer action for post subcribge
    includePostSubscribeAttribution: "includePostSubscribeAttribution",
    // Campaign Token
    campaignToken: "ct",
    // Provider Token
    providerToken: "pt",
    // Q Token
    qToken: "its_qt",
    // Advertisement ID
    advertisementId: "adId",
    // The token used to pass arbitrary data in a url
    token: "token",
    // The current parse context for the a page
    parseContext: "parseContext",
    // An ID for a privacy type
    privacyTypeId: "privacyTypeId",
    // The token used to pass arbitrary data in a url
    requestDescriptor: "requestDescriptor",
    // Page Facet
    ageRating: "ageRating",
    // Page Facet
    controllerSupport: "controllerSupport",
    // Page Facet
    multiplayerSupport: "multiplayerSupport",
    // Page Facet
    comingSoon: "comingSoon",
    // Page Facet
    binCompatGames: "binCompatGames",
    // Page Facet
    gamePreviews: "gamePreviews",
    // Upsell (marketing item) marketing hint
    offerHints: "offerHints",
    // Indicates that a 204 network error should invalidate the App Store's widgets.
    invalidateWidgetsOnFailure: "invalidateWidgetsOnFailure",
    // Metrics
    metrics: "metrics",
    // App event ID
    appEventId: "eventid",
    // Offer Item ID
    offerItemId: "offerItemId",
    // App event deep link
    appEventDeepLink: "deepLink",
    // The use case param for collection deeplinking
    useCaseShort: "uc",
    // The collection id param for collection deeplinking
    collectionId: "collection-id",
    // The seed id param for collection deeplinking
    seedId: "seed-id",
    // Whether the shelf is the product page similar items shelf.
    isShelfWithAd: "isShelfWithAd",
    // The ad placement type for the shelf. Only used if `isShelfWithAd` is true.
    shelfWithAdPlacementType: "shelfWithAdPlacementType",
    // Provides a refresh type to route a refresh request for a shelf.
    // See `refreshUrl` on `Shelf`.
    shelfRefreshType: "refreshType",
    // Param to denote that this url originated for preloading purposes.
    isPreloading: "isPreloading",
    // The name parameter for editorial pages with known names
    name: "name",
    // The editorial page shelf type
    shelfType: "shelfType",
    // The id of the shelf in a url
    shelfId: "shelfId",
    // Parameter for the onboarding cards for the today tab
    onbaordingCardIds: "onboardingCardIds",
    // Parameter for the today card previews to provide a future date and time
    preview: "preview",
    // The card config for used for the card on a today page
    todayCardConfig: "todayCardConfig",
    // The parameter that is expanded into the header used for today previews.
    experimentId: "experimentId",
    shortEditorialNotes: "shortEditorialNotes",
    // User subscription status defined by Mercury and passed to Arcade download pack onboarding.
    // It is used to select the right copy variant.
    arcadeSubscriptionStatus: "subscriptionStatus",
    // Used to indicate a web browser is being displayed in the web browser context via App Store Components.
    webBrowser: "webBrowser",
    // The id of the editorial-page that was used to create a url
    editorialPageId: "editorialPageId",
    // A filter ID to add to a editorial item request in order to fetch a certain version of the story.
    editorialCardId: "filter[canvas:cardId]",
    // A filter to add to the hydration call for the Today tab recommended candidates to fetch only recommendable apps.
    filterRecommendable: "filter[recommendable]",
    // A device family, used for accessibility labels
    deviceFamily: "deviceFamily",
};
// Install Page-specific parameters
export const InAppPurchaseInstallPageParameters = {
    // The adamId for the IAP.
    inAppPurchaseId: "inAppPurchaseId",
};
// Product Page-specific parameters
export const ProductPageParameters = {
    // Product URL
    url: "productUrl",
    // Whether an iAP is a subscription.
    isSubscription: "isSubscription",
    // The minimum version of the app to display
    // Typically used to prevent older cached versions being displayed
    // when deep-linking from an app clip.
    minExternalVersionId: "minExternalVersionId",
};
// Review Page-specific parameters
export const ReviewsPageParameters = {
    // Product adamId
    adamId: "adamId",
    // Sort index for the reviews request
    sort: "sort",
};
export const MSOPageParameters = {
    // Ids of available apps.
    availableAdamIds: "availableAdamIds",
};
export const ShelfParameters = {
    // Shelf Title
    title: "shelfTitle",
    // Whether the shelf should auto-configure a see-all on fetch
    shouldInferSeeAllFromFetchedItems: "shelfShouldInferSeeAllFromFetchedItems",
    // Shelf content type
    contentType: "shelfContentType",
    // Shelf offer them
    offerTheme: "shelfOfferTheme",
    // metrics page information
    metricsPageInformation: "metricsPage",
};
export const ShareURLParameters = {
    // Which client should be the link be opened with
    clientSpecifier: "app",
};
export const Hashes = {
    // Reviews action anchor (#reviews)
    reviews: "reviews",
};
export const ShelfRefreshType = {
    productPageSimilarItems: "productPageSimilarItems",
};
/* tslint:enable:variable-name */
//# sourceMappingURL=url-constants.js.map