import { isNothing } from "@jet/environment/types/optional";
/**
 * Iterate the cookies contained in a string.
 *
 * @param cookie A string containing zero or more cookies.
 */
export function* cookiesOf(cookie) {
    if (isNothing(cookie)) {
        return;
    }
    const rawEntries = cookie.split(";");
    for (const rawEntry of rawEntries) {
        const keyEndIndex = rawEntry.indexOf("=");
        if (keyEndIndex === -1) {
            // If there's no splitter, treat the whole raw
            // entry as the key and provide an empty value.
            const key = decodeURIComponent(rawEntry).trim();
            yield { key, value: "" };
        }
        else {
            const key = decodeURIComponent(rawEntry.substring(0, keyEndIndex)).trim();
            const value = decodeURIComponent(rawEntry.substring(keyEndIndex + 1)).trim();
            yield { key, value };
        }
    }
}
//# sourceMappingURL=cookies.js.map