import * as appStoreExperiments from "./app-store-experiments";
import { ExperimentAreaId } from "./experiment-area-id";
/**
 * Check whether the condensed treatment should be applied to the Today ad.
 * @param objectGraph The object graph.
 * @returns A boolean indicating if the treatment should be applied.
 */
export function shouldTodayAdBeCondensed(objectGraph) {
    if (!objectGraph.client.isPhone) {
        return false;
    }
    const treatmentId = appStoreExperiments.currentTreatmentIdForArea(objectGraph, ExperimentAreaId.CondensedTodayAds);
    return treatmentId === "5pdfhju01" /* TodayAdCondensedDisplayExperimentTypes.Condensed */;
}
//# sourceMappingURL=today-ad-experiments.js.map