import * as appStoreExperiments from "./app-store-experiments";
import { ExperimentAreaId } from "./experiment-area-id";
export function shouldSkipProductPagePreload(objectGraph) {
    const treatmentId = appStoreExperiments.currentTreatmentIdForArea(objectGraph, ExperimentAreaId.ProductPagePreloading);
    return treatmentId === "3NepyQj01" /* ProductPagePreloadingExperimentTypes.SkipPreload */;
}
// --- Product Page Variants --
/// Returns the treatment group id based on xp_ab value as string.
export function productVariantTreatmentId(objectGraph) {
    return appStoreExperiments.currentTreatmentIdForArea(objectGraph, ExperimentAreaId.ProductPageVariants);
}
/**
 * The number of rows that the YMAL shelf should use.
 * @param objectGraph The object graph.
 * @returns A number representing the number of rows in the YMAL shelf.
 */
export function ymalShelfNumberOfRows(objectGraph) {
    const treatmentId = appStoreExperiments.currentTreatmentIdForArea(objectGraph, ExperimentAreaId.ProductPageYMALRowCount);
    return treatmentId === "2S6U3Dq01" /* ProductPageYMALShelfRowNumberExperimentTypes.ThreeRow */ ? 3 : 2;
}
//# sourceMappingURL=product-page-experiments.js.map