import { injectSEOData } from "../../api/models/web-renderable-page";
import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { chartsPageRoutes, makeChartsPageURL } from "../../common/charts/charts-page-url";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
import { fetchAndRenderTopChartPage } from "../../common/top-charts/top-charts-page";
import { validateGenreId } from "../../foundation/media/util";
export const ChartsPageIntentController = {
    $intentKind: "ChartsPageIntent",
    routes: chartsPageRoutes,
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            var _a;
            // See: https://github.pie.apple.com/its/Jingle/blob/aaccec936f1feed227fd171ae66bb160cf38e497/MZStorePlatform/src/main/clojure/jingle/store/platform/api/controller/categories.clj#L135
            validateGenreId(objectGraph, intent.genreId);
            const page = await fetchAndRenderTopChartPage(objectGraph, intent.genreId, null, intent.chart, intent.ageBandId);
            if (objectGraph.client.isWeb) {
                injectWebNavigation(objectGraph, page, intent.platform);
                injectSEOData(page, (_a = objectGraph.seo) === null || _a === void 0 ? void 0 : _a.getSEODataForChartsPage(objectGraph, page, null));
            }
            page.canonicalURL = makeChartsPageURL(objectGraph, intent);
            return page;
        });
    },
};
//# sourceMappingURL=charts-page-intent-controller.js.map