import { isNothing } from "@jet/environment";
import { makeSearchLandingPageIntent, } from "../../api/intents/search/search-landing-page-intent";
import { generateRoutes } from "../../common/util/generate-routes";
import { fetchPage } from "../../common/search/search-landing-page-utils";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { injectSEOData } from "../../api/models/web-renderable-page";
import { validateNeedsVisionRestriction } from "../../foundation/media/util";
const { routes, makeCanonicalUrl } = generateRoutes(makeSearchLandingPageIntent, "/{platform}/search");
export const SearchLandingPageIntentController = {
    $intentKind: "SearchLandingPageIntent",
    routes,
    async perform(intent, objectGraphWithoutActiveIntent) {
        if (objectGraphWithoutActiveIntent.client.isWeb && !intent.platform) {
            // Search on the "web" client requires a platform; if we don't have one from the `Intent`, we should
            // assume we want `iphone` results
            intent.platform = "iphone";
        }
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            var _a;
            validateNeedsVisionRestriction(objectGraph);
            const searchLandingPage = await fetchPage(objectGraph);
            if (isNothing(searchLandingPage.canonicalURL)) {
                searchLandingPage.canonicalURL = makeCanonicalUrl(objectGraph, intent);
            }
            if (objectGraph.client.isWeb) {
                injectWebNavigation(objectGraph, searchLandingPage, intent.platform);
                injectSEOData(searchLandingPage, (_a = objectGraph.seo) === null || _a === void 0 ? void 0 : _a.getSEODataForSearchLandingPage(objectGraph, searchLandingPage, null));
            }
            return searchLandingPage;
        });
    },
};
//# sourceMappingURL=search-landing-page-intent-controller.js.map