import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { fetchData } from "../../foundation/media/network";
import { roomPageRoutes as routes, makeCanonicalRoomPageUrl } from "../../common/room/room-common";
import { createRoomRequest } from "../../common/room/room-request";
import { renderRoomPage } from "../../common/room/room-page";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
import { injectSEOData } from "../../api/models/web-renderable-page";
import { validateFcId } from "../../foundation/media/util";
export const RoomPageIntentController = {
    $intentKind: "RoomPageIntent",
    routes,
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            var _a;
            // See: https://github.pie.apple.com/its/Jingle/blob/d2d051c9ef2891f72d5f02f5bbbf2d7748afa7b9/MZStoreComponents/src/main/java/com/apple/jingle/app/store/editorial/SFEditorialHelper.java#L293
            validateFcId(objectGraph, intent.id);
            const mediaApiRequest = createRoomRequest(objectGraph, intent.id);
            const response = await fetchData(objectGraph, mediaApiRequest);
            const page = renderRoomPage(objectGraph, response);
            page.canonicalURL = makeCanonicalRoomPageUrl(objectGraph, intent);
            if (objectGraph.client.isWeb) {
                injectWebNavigation(objectGraph, page, intent.platform);
                injectSEOData(page, (_a = objectGraph.seo) === null || _a === void 0 ? void 0 : _a.getSEODataForRoomPage(objectGraph, page, response));
            }
            return page;
        });
    },
};
//# sourceMappingURL=room-page-intent-controller.js.map