import { injectSEOData } from "../../api/models/web-renderable-page";
import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import * as mediaNetwork from "../../foundation/media/network";
import { validateAdamId } from "../../foundation/media/util";
import { mediaApiProductSeeAllRequest } from "../../common/builders/url-mapping";
import { createProductPageFromResponse } from "../../common/product-page/product-page-util";
import { seeAllPageRoutes } from "../../common/product-page/intent-controller-routing";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
export const SeeAllPageIntentController = {
    $intentKind: "SeeAllPageIntent",
    routes: seeAllPageRoutes,
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            var _a, _b;
            validateAdamId(objectGraph, intent.id);
            const seeAllRequest = mediaApiProductSeeAllRequest(objectGraph, intent.id, intent["see-all"]);
            const seeAllResponse = await mediaNetwork.fetchData(objectGraph, seeAllRequest);
            const page = (await createProductPageFromResponse(objectGraph, seeAllResponse));
            if (objectGraph.client.isWeb) {
                // Synthesize the URL for the page based on the product page URL and the expected query param
                if (page.canonicalURL) {
                    const pageURL = new URL(page.canonicalURL);
                    const params = pageURL.searchParams;
                    params.set("see-all", intent["see-all"]);
                    params.set("platform", intent.platform);
                    if (intent.platform) {
                        params.set("platform", intent.platform);
                    }
                    page.canonicalURL = pageURL.toString();
                }
                page.seeAllType = intent["see-all"];
                injectWebNavigation(objectGraph, page, intent.platform);
                injectSEOData(page, (_b = (_a = objectGraph.seo) === null || _a === void 0 ? void 0 : _a.getSEODataForSeeAllPage) === null || _b === void 0 ? void 0 : _b.call(_a, objectGraph, page, seeAllResponse));
            }
            return page;
        });
    },
};
//# sourceMappingURL=see-all-intent-controller.js.map