import { makeBundlePageIntent as baseMakeBundlePageIntent, } from "../../api/intents/bundle-page-intent";
import { injectSEOData } from "../../api/models/web-renderable-page";
import { generateRoutes } from "../../common/util/generate-routes";
import { makeBundlePageRequest } from "../../common/product-page/bundle-page-common";
import { createProductPageFromResponse } from "../../common/product-page/shelf-based/shelf-based-product-page";
import { inferPreviewPlatformFromDeviceFamilies } from "../../common/preview-platform";
import * as mediaNetwork from "../../foundation/media/network";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { URL } from "../../foundation/network/urls";
import { validateAdamId } from "../../foundation/media/util";
function makeBundlePageIntent(opts) {
    const { ...clone } = opts;
    // The `{bundleName}` dynamic segment is part of the URL for SEO purposes, but is not actually part
    // of the `Intent` since it is not necessary for data-fetching. This data must not end up as
    // part of the `Intent` as the value cannot be consistently normalized, which can break important
    // caching behavior within the `web` client
    delete clone["bundleName"];
    return baseMakeBundlePageIntent(clone);
}
// @ts-expect-error `generateRoutes` does not handle a typed `Platform` value correctly
const { routes } = generateRoutes(makeBundlePageIntent, "/app-bundle/{bundleName}/{id}", [], {
    optionalQuery: ["platform", "lic"],
});
export const BundlePageIntentController = {
    $intentKind: "BundlePageIntent",
    routes,
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            var _a, _b;
            // See: https://github.pie.apple.com/its/Jingle/blob/ce14e21b6ac3dd4be884aa12b26d4e79c6d8aa7a/MZStorePlatform/src/main/java/com/apple/jingle/store/mediaapi/resource/SFMediaAPICommonResourceType.java#L47
            validateAdamId(objectGraph, intent.id);
            const mediaApiRequest = makeBundlePageRequest(objectGraph, intent);
            const response = await mediaNetwork.fetchData(objectGraph, mediaApiRequest);
            const previewPlatform = (_a = intent.platform) !== null && _a !== void 0 ? _a : inferPreviewPlatformFromDeviceFamilies(objectGraph, response);
            if (!objectGraph.activeIntent.previewPlatform) {
                objectGraph.activeIntent.setInferredPreviewPlatform(previewPlatform);
            }
            const page = await createProductPageFromResponse(objectGraph, response);
            // The page URL (`.canonicalURL` property on the view-model) from Media API does not account for the `platform`
            // query param; we need to add that in ourselves. We can't rely on `makeCanonicalUrl` as that does not handle the
            // `bundleName` segment; we need to take the Media API URL and append the `platform` ourselves
            if (page.canonicalURL) {
                const pageURL = new URL(page.canonicalURL);
                if (intent.platform) {
                    pageURL.param("platform", intent.platform);
                }
                if (intent.lic) {
                    pageURL.param("lic", intent.lic);
                }
                page.canonicalURL = pageURL.toString();
            }
            if (objectGraph.client.isWeb) {
                injectWebNavigation(objectGraph, page, previewPlatform);
                injectSEOData(page, (_b = objectGraph.seo) === null || _b === void 0 ? void 0 : _b.getSEODataForBundlePage(objectGraph, page, response));
            }
            return page;
        });
    },
};
//# sourceMappingURL=bundle-page-intent-controller.js.map