import { isNothing } from "@jet/environment/types/optional";
import { fetchData } from "../../foundation/media/network";
import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { makeBaseGroupingPageRequest, prepareGroupingPageRequest } from "../../common/grouping/grouping-request";
import { flattenedGroupingFromDataContainer, groupingPageFromFlattenedGrouping, groupingParseContextFromDataContainer, } from "../../common/grouping/render-grouping-page";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
import { setPreviewPlatform } from "../../common/preview-platform";
import { groupingPageRoutes as routes, makeGroupingPageCanonicalURL } from "../../common/grouping/grouping-page-url";
import { injectSEOData } from "../../api/models/web-renderable-page";
import { validateGroupingId } from "../../foundation/media/util";
function makeMediaApiGroupingPageRequest(objectGraph, intent) {
    const mediaApiRequest = makeBaseGroupingPageRequest(objectGraph);
    if ("name" in intent) {
        mediaApiRequest.addingQuery("name", intent.name);
    }
    else {
        mediaApiRequest.withIdOfType(intent.id, "groupings");
    }
    if ("tabs" in intent) {
        mediaApiRequest.addingQuery("tabs", intent.tabs);
    }
    prepareGroupingPageRequest(objectGraph, mediaApiRequest);
    setPreviewPlatform(objectGraph, mediaApiRequest);
    return mediaApiRequest;
}
export const GroupingPageIntentController = {
    $intentKind: "GroupingPageIntent",
    routes,
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            var _a;
            if ("id" in intent) {
                // See: https://github.pie.apple.com/its/Jingle/blob/aaccec936f1feed227fd171ae66bb160cf38e497/MZStorePlatform/src/main/clojure/jingle/store/platform/api/realm/apps/apps_endpoints.clj#L1554
                // See: https://github.pie.apple.com/its/Jingle/blob/aaccec936f1feed227fd171ae66bb160cf38e497/MZStorePlatform/src/main/clojure/jingle/store/platform/api/controller/editorial_resource.clj#L9
                // See: https://github.pie.apple.com/its/Jingle/blob/aaccec936f1feed227fd171ae66bb160cf38e497/MZStorePlatform/src/main/java/com/apple/jingle/store/mediaapi/util/SFMediaAPIEditorialUtil.java#L585
                // See: https://github.pie.apple.com/its/Jingle/blob/aaccec936f1feed227fd171ae66bb160cf38e497/MZStorePlatform/src/main/java/com/apple/jingle/store/mediaapi/util/SFMediaAPIEditorialUtil.java#L633-L639
                validateGroupingId(objectGraph, intent.id);
            }
            const mediaApiRequest = makeMediaApiGroupingPageRequest(objectGraph, intent);
            const response = await fetchData(objectGraph, mediaApiRequest);
            const flattenedGrouping = flattenedGroupingFromDataContainer(objectGraph, response);
            const groupingParseContext = groupingParseContextFromDataContainer(objectGraph, response);
            if (isNothing(flattenedGrouping) || isNothing(groupingParseContext)) {
                return null;
            }
            const page = groupingPageFromFlattenedGrouping(objectGraph, flattenedGrouping, groupingParseContext);
            if ("id" in intent) {
                page.canonicalURL = makeGroupingPageCanonicalURL(objectGraph, intent);
            }
            if (objectGraph.client.isWeb) {
                injectWebNavigation(objectGraph, page, intent.platform);
                injectSEOData(page, (_a = objectGraph.seo) === null || _a === void 0 ? void 0 : _a.getSEODataForGroupingPage(objectGraph, page, response));
            }
            return page;
        });
    },
};
//# sourceMappingURL=grouping-page-intent-controller.js.map