import { isNothing } from "@jet/environment";
import { renderPage as renderEditorialPage } from "../../common/editorial-pages/editorial-page-controller-util";
import { makeEditorialPageRequest } from "../../common/editorial-pages/editorial-page-media-api-utils";
import * as mediaNetwork from "../../foundation/media/network";
import { FlowAction } from "../../api/models";
import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { isEditorialPageIntentByID } from "../../api/intents/editorial/editorial-page-intent";
import { editorialPageRoutes, makeEditorialPageURL, } from "../../common/editorial-pages/editorial-page-intent-controller-utils";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
import { injectSEOData } from "../../api/models/web-renderable-page";
import { validateAdamId, validateNeedsVisionRestriction } from "../../foundation/media/util";
export const EditorialPageIntentController = {
    $intentKind: "EditorialPageIntent",
    routes(objectGraph) {
        return editorialPageRoutes(objectGraph);
    },
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            var _a;
            if ("id" in intent) {
                // See: https://github.pie.apple.com/its/Jingle/blob/ce14e21b6ac3dd4be884aa12b26d4e79c6d8aa7a/MZStorePlatform/src/main/java/com/apple/jingle/store/mediaapi/resource/SFMediaAPICommonResourceType.java#L91
                validateAdamId(objectGraph, intent.id);
            }
            validateNeedsVisionRestriction(objectGraph);
            const mediaApiRequest = makeEditorialPageRequest(objectGraph, intent);
            const response = await mediaNetwork.fetchData(objectGraph, mediaApiRequest);
            const editorialPage = await renderEditorialPage(objectGraph, response, {
                isArcadePage: false,
            });
            if (isNothing(editorialPage)) {
                const notFoundError = new mediaNetwork.NetworkError("Media API response lacked required data");
                notFoundError.statusCode = 404;
                throw notFoundError;
            }
            // The Media API often does not provide a URL; if that is the case, synthesize one
            if (isNothing(editorialPage.canonicalURL) && isEditorialPageIntentByID(intent)) {
                editorialPage.canonicalURL = makeEditorialPageURL(objectGraph, intent);
            }
            if (objectGraph.client.isWeb) {
                injectWebNavigation(objectGraph, editorialPage, intent.platform);
                injectSEOData(editorialPage, (_a = objectGraph.seo) === null || _a === void 0 ? void 0 : _a.getSEODataForEditorialPage(objectGraph, editorialPage, response));
            }
            return editorialPage;
        });
    },
    actionFor(intent, objectGraph) {
        const action = new FlowAction("page");
        action.destination = intent;
        if (isEditorialPageIntentByID(intent)) {
            action.pageUrl = makeEditorialPageURL(objectGraph, intent);
        }
        return action;
    },
};
//# sourceMappingURL=editorial-page-intent-controller.js.map