import { Path } from "../../foundation/network/url-constants";
import { makeDeveloperPageIntent } from "../../api/intents/developer-page-intent";
import { generateRoutes } from "../../common/util/generate-routes";
import { makeDeveloperRequest } from "../../common/developer/developer-request";
import { fetchData } from "../../foundation/media/network";
import { developerPageFromResponse } from "../../common/developer/developer-common";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
import { injectSEOData } from "../../api/models/web-renderable-page";
import { validateAdamId } from "../../foundation/media/util";
const { routes } = generateRoutes(makeDeveloperPageIntent, `/${Path.developer}/{name}/{id}`);
export const DeveloperPageIntentController = {
    $intentKind: "DeveloperPageIntent",
    routes,
    async perform(intent, objectGraph) {
        var _a;
        // See: https://github.pie.apple.com/its/Jingle/blob/ce14e21b6ac3dd4be884aa12b26d4e79c6d8aa7a/MZStorePlatform/src/main/java/com/apple/jingle/store/mediaapi/resource/SFMediaAPICommonResourceType.java#L52
        validateAdamId(objectGraph, intent.id);
        const mediaApiRequest = makeDeveloperRequest(objectGraph, intent.id);
        const response = await fetchData(objectGraph, mediaApiRequest);
        const page = developerPageFromResponse(objectGraph, response);
        if (objectGraph.client.isWeb) {
            injectWebNavigation(objectGraph, page);
            injectSEOData(page, (_a = objectGraph.seo) === null || _a === void 0 ? void 0 : _a.getSEODataForDeveloperPage(objectGraph, page, response));
        }
        return page;
    },
};
//# sourceMappingURL=developer-page-intent-controller.js.map