import { createPlatformSelectors } from "./platform-selection";
import { createLandingPageLinks } from "./landing-page-links-by-platform";
import { makeWebSearchAction } from "../search/web-search-action";
/**
 * Create a {@linkcode WebNavigation} based on the active {@linkcode Intent}
 */
export function createWebNavigation(objectGraph, platform) {
    const webNavigation = {
        platforms: [],
        tabs: [],
        searchAction: makeWebSearchAction(objectGraph, platform),
    };
    setActivePlatform(objectGraph, webNavigation, platform);
    return webNavigation;
}
/**
 * Updates a {@linkcode WebNavigation} to reflect:
 *
 * 1. the platform specified by {@linkcode platform}
 * 2. the "active landing page" specified by {@linkcode intent}
 */
export function setActivePlatform(objectGraph, shelf, platform, intent) {
    shelf.platforms = createPlatformSelectors(objectGraph, platform);
    const searchActionDestination = shelf.searchAction.destination;
    shelf.tabs = createLandingPageLinks(objectGraph, platform, intent);
    searchActionDestination.platform = platform;
}
//# sourceMappingURL=web-navigation.js.map