import { allPreviewPlatforms } from "../../api/models/preview-platform";
import { makeCanonicalSearchResultsPageUrl } from "../search/search-page-url";
function replaceDestinationIntent(objectGraph, action, intent, platform) {
    const updatedIntent = {
        ...intent,
        platform,
    };
    action.destination = updatedIntent;
    action.pageUrl = makeCanonicalSearchResultsPageUrl(objectGraph, updatedIntent);
}
/**
 * Replaces each of the "platform selector" actions with one that navigates to the
 * {@linkcode searchResultsPageIntent} in each platform
 *
 * This is necessary because the existing platform selector, which normally takes
 * the user to a platform landing page, instead takes the user to the search results
 * page within the selected platform
 */
export function replacePlatformSelectorDestinationWithSearchResults(objectGraph, webNavigation, searchResultsPageIntent) {
    const isVisionSupported = objectGraph.bag.enableVisionPlatform;
    allPreviewPlatforms
        // Rejects vision if its not supported and let's all other platforms pass
        .filter((platform) => isVisionSupported || platform !== "vision")
        .forEach((platform, index) => {
        replaceDestinationIntent(objectGraph, webNavigation.platforms[index].action, searchResultsPageIntent, platform);
    });
}
//# sourceMappingURL=search-results-platform-selection.js.map