import { allPreviewPlatforms } from "../../api/models/preview-platform";
import { iPadTodayPageController, WatchDiscoverController, VisionAppsAndGamesController, MacDiscoverController, iPhoneTodayPageController, TVDiscoverController, } from "./platform-landing-page-intent-controllers";
import { unreachable } from "../../foundation/util/errors";
import { getLocale } from "../locale";
import { createArtworkForSystemImage } from "../content/artwork/artwork";
import * as metricsHelpersClicks from "../metrics/helpers/clicks";
import { newLocationTracker } from "../metrics/helpers/location";
function makeiPhonePlatformSelector(objectGraph, isActive) {
    const action = iPhoneTodayPageController.buildAction(getLocale(objectGraph), objectGraph);
    action.title = objectGraph.loc.string("Web.Navigation.Platform.Phone");
    action.artwork = createArtworkForSystemImage(objectGraph, "iphone.gen2");
    return {
        action,
        isActive,
    };
}
function makeiPadPlatformSelector(objectGraph, isActive) {
    const action = iPadTodayPageController.buildAction(getLocale(objectGraph), objectGraph);
    action.title = objectGraph.loc.string("Web.Navigation.Platform.Pad");
    action.artwork = createArtworkForSystemImage(objectGraph, "ipad.gen2.landscape");
    return {
        action,
        isActive,
    };
}
function makeMacPlatformSelector(objectGraph, isActive) {
    const action = MacDiscoverController.buildAction(getLocale(objectGraph), objectGraph);
    action.title = objectGraph.loc.string("Web.Navigation.Platform.Mac");
    action.artwork = createArtworkForSystemImage(objectGraph, "macbook.gen2");
    return {
        action,
        isActive,
    };
}
function makeVisionPlatformSelector(objectGraph, isActive) {
    const action = VisionAppsAndGamesController.buildAction(getLocale(objectGraph), objectGraph);
    action.title = objectGraph.loc.string("Web.Navigation.Platform.Vision");
    action.artwork = createArtworkForSystemImage(objectGraph, "visionpro");
    return {
        action,
        isActive,
    };
}
function makeWatchPlatformSelector(objectGraph, isActive) {
    const action = WatchDiscoverController.buildAction(getLocale(objectGraph), objectGraph);
    action.title = objectGraph.loc.string("Web.Navigation.Platform.Watch");
    action.artwork = createArtworkForSystemImage(objectGraph, "applewatch");
    return {
        action,
        isActive,
    };
}
function makeTVPlatformSelector(objectGraph, isActive) {
    const action = TVDiscoverController.buildAction(getLocale(objectGraph), objectGraph);
    action.title = objectGraph.loc.string("Web.Navigation.Platform.TV");
    action.artwork = createArtworkForSystemImage(objectGraph, "tv");
    return {
        action,
        isActive,
    };
}
function makePlatformSelector(objectGraph, platform, activePlatform) {
    let selector;
    switch (platform) {
        case "iphone": {
            selector = makeiPhonePlatformSelector(objectGraph, activePlatform === "iphone");
            break;
        }
        case "ipad": {
            selector = makeiPadPlatformSelector(objectGraph, activePlatform === "ipad");
            break;
        }
        case "mac": {
            selector = makeMacPlatformSelector(objectGraph, activePlatform === "mac");
            break;
        }
        case "vision": {
            selector = makeVisionPlatformSelector(objectGraph, activePlatform === "vision");
            break;
        }
        case "watch": {
            selector = makeWatchPlatformSelector(objectGraph, activePlatform === "watch");
            break;
        }
        case "tv": {
            selector = makeTVPlatformSelector(objectGraph, activePlatform === "tv");
            break;
        }
        default:
            unreachable(platform);
    }
    if (objectGraph.client.isWeb) {
        metricsHelpersClicks.addClickEventToAction(objectGraph, selector.action, {
            id: platform,
            actionType: "navigate",
            locationTracker: newLocationTracker(),
            pageInformation: undefined,
        }, false, "link");
    }
    return selector;
}
/**
 *
 * @param objectGraph
 * @param activePlatform the active platform; navigation links to it will be presented with an "active" style
 * @returns
 */
export function createPlatformSelectors(objectGraph, activePlatform) {
    const isVisionSupported = objectGraph.bag.enableVisionPlatform;
    return (allPreviewPlatforms
        // Rejects vision if its not supported and let's all other platforms pass
        .filter((platform) => isVisionSupported || platform !== "vision")
        .map((platform) => makePlatformSelector(objectGraph, platform, activePlatform)));
}
//# sourceMappingURL=platform-selection.js.map