// This module, despite exporting `IntentController` definitions, lives inside of
// `src/common` because these controllers need to be import-able by other "common"
// code in order to directly call their `buildIntent` method
//
// The "web" client expects all exports from this module to be `IntentController` instances
import { defineLandingPageController, definePlatformRootRedirectController, defineRootRedirectController, } from "./platform-landing-page-utils";
import { makeEditorialPageIntentByName } from "../../api/intents/editorial/editorial-page-intent";
import { makeGroupingPageIntentByName } from "../../api/intents/grouping-page-intent";
import { makeRoutableTodayPageIntent } from "../../api/intents/routable-today-page-intent";
import { makeArcadeGroupingPageIntent } from "../../api/intents/arcade-grouping-page-intent";
import { appLandingPageFlowActionPresentation, appAndGamesLandingPageFlowActionPresentation, arcadeLandingPageFlowActionPresentation, discoverLandingPageFlowActionPresentation, gamesLandingPageFlowActionPresentation, createLandingPageFlowActionPresentation, workLandingPageFlowActionPresentation, playLandingPageFlowActionPresentation, todayLandingPageFlowActionPresentation, developLandingPageFlowActionPresentation, categoriesLandingPageFlowActionPresentation, searchLandingPageFlowActionPresentation, } from "./flow-action-presentation";
import { makeSearchLandingPageIntent } from "../../api/intents/search/search-landing-page-intent";
// Ensures that the root URL (e.g. apps.apple.com) redirects to the iPhone Today page
export const RootRedirectController = defineRootRedirectController((locale) => iPhoneTodayPageController.buildIntent(locale));
/// MARK: Vision Pro Landing Pages
export const VisionRootRedirectController = definePlatformRootRedirectController("/vision", (locale) => VisionAppsAndGamesController.buildIntent(locale));
export const VisionAppsAndGamesController = defineLandingPageController("/vision/apps-and-games", (locale) => makeEditorialPageIntentByName({
    ...locale,
    platform: "vision",
    name: "apps-and-games",
}), appAndGamesLandingPageFlowActionPresentation);
export const VisionArcadeController = defineLandingPageController("/vision/arcade", (locale) => makeEditorialPageIntentByName({
    ...locale,
    platform: "vision",
    name: "arcade-subscriber",
}), arcadeLandingPageFlowActionPresentation);
export const VisionSearchLandingController = defineLandingPageController("/vision/search", (locale) => makeSearchLandingPageIntent({
    ...locale,
    platform: "vision",
}), searchLandingPageFlowActionPresentation);
/// MARK: Mac Landing Pages
export const MacRootRedirectController = definePlatformRootRedirectController("/mac", (locale) => MacDiscoverController.buildIntent(locale));
export const MacDiscoverController = defineLandingPageController("/mac/discover", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "mac",
    name: "apps",
}), discoverLandingPageFlowActionPresentation);
export const MacArcadeController = defineLandingPageController("/mac/arcade", (locale) => makeArcadeGroupingPageIntent({
    ...locale,
    platform: "mac",
}), arcadeLandingPageFlowActionPresentation);
export const MacCreateController = defineLandingPageController("/mac/create", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "mac",
    name: "create",
}), createLandingPageFlowActionPresentation);
export const MacWorkController = defineLandingPageController("/mac/work", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "mac",
    name: "work",
}), workLandingPageFlowActionPresentation);
export const MacPlayController = defineLandingPageController("/mac/play", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "mac",
    name: "play",
}), playLandingPageFlowActionPresentation);
export const MacDevelopController = defineLandingPageController("/mac/develop", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "mac",
    name: "develop",
}), developLandingPageFlowActionPresentation);
export const MacCategoriesController = defineLandingPageController("/mac/categories", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "mac",
    name: "categories",
}), categoriesLandingPageFlowActionPresentation);
export const MacSearchLandingController = defineLandingPageController("/mac/search", (locale) => makeSearchLandingPageIntent({
    ...locale,
    platform: "mac",
}), searchLandingPageFlowActionPresentation);
/// MARK: iPhone Landing Pages
export const iPhoneRootRedirectController = definePlatformRootRedirectController("/iphone", (locale) => iPhoneTodayPageController.buildIntent(locale));
export const iPhoneTodayPageController = defineLandingPageController("/iphone/today", (locale) => makeRoutableTodayPageIntent({
    ...locale,
    platform: "iphone",
}), todayLandingPageFlowActionPresentation);
export const iPhoneAppsController = defineLandingPageController("/iphone/apps", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "iphone",
    name: "apps",
}), appLandingPageFlowActionPresentation);
export const iPhoneGamesController = defineLandingPageController("/iphone/games", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "iphone",
    name: "games",
}), gamesLandingPageFlowActionPresentation);
export const iPhoneArcadeController = defineLandingPageController("/iphone/arcade", (locale) => makeArcadeGroupingPageIntent({
    ...locale,
    platform: "iphone",
}), arcadeLandingPageFlowActionPresentation);
export const iPhoneSearchLandingController = defineLandingPageController("/iphone/search", (locale) => makeSearchLandingPageIntent({
    ...locale,
    platform: "iphone",
}), searchLandingPageFlowActionPresentation);
/// MARK: iPad Landing Pages
export const iPadRootRedirectController = definePlatformRootRedirectController("/ipad", (locale) => iPadTodayPageController.buildIntent(locale));
export const iPadTodayPageController = defineLandingPageController("/ipad/today", (locale) => makeRoutableTodayPageIntent({
    ...locale,
    platform: "ipad",
}), todayLandingPageFlowActionPresentation);
export const iPadGamesController = defineLandingPageController("/ipad/games", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "ipad",
    name: "games",
}), gamesLandingPageFlowActionPresentation);
export const iPadAppsController = defineLandingPageController("/ipad/apps", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "ipad",
    name: "apps",
}), appLandingPageFlowActionPresentation);
export const iPadArcadeController = defineLandingPageController("/ipad/arcade", (locale) => makeArcadeGroupingPageIntent({
    ...locale,
    platform: "ipad",
}), arcadeLandingPageFlowActionPresentation);
export const iPadSearchLandingController = defineLandingPageController("/ipad/search", (locale) => makeSearchLandingPageIntent({
    ...locale,
    platform: "ipad",
}), searchLandingPageFlowActionPresentation);
/// MARK: Watch Landing Pages
export const WatchRootRedirectController = definePlatformRootRedirectController("/watch", (locale) => WatchDiscoverController.buildIntent(locale));
export const WatchDiscoverController = defineLandingPageController("/watch/apps-and-games", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "watch",
    name: "apps",
}), appAndGamesLandingPageFlowActionPresentation);
export const WatchSearchLandingController = defineLandingPageController("/watch/search", (locale) => makeSearchLandingPageIntent({
    ...locale,
    platform: "watch",
}), searchLandingPageFlowActionPresentation);
/// MARK: TV Landing Pages
export const TVRootRedirectController = definePlatformRootRedirectController("/tv", (locale) => TVDiscoverController.buildIntent(locale));
export const TVDiscoverController = defineLandingPageController("/tv/discover", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "tv",
    name: "discover",
}), discoverLandingPageFlowActionPresentation);
export const TVGamesController = defineLandingPageController("/tv/games", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "tv",
    name: "games",
}), gamesLandingPageFlowActionPresentation);
export const TVAppsController = defineLandingPageController("/tv/apps", (locale) => makeGroupingPageIntentByName({
    ...locale,
    platform: "tv",
    name: "apps",
}), appLandingPageFlowActionPresentation);
export const TVArcadeController = defineLandingPageController("/tv/arcade", (locale) => makeArcadeGroupingPageIntent({
    ...locale,
    platform: "tv",
}), arcadeLandingPageFlowActionPresentation);
export const TVSearchLandingController = defineLandingPageController("/tv/search", (locale) => makeSearchLandingPageIntent({
    ...locale,
    platform: "tv",
}), searchLandingPageFlowActionPresentation);
//# sourceMappingURL=platform-landing-page-intent-controllers.js.map