import { isPreviewPlatform } from "../../api/models/preview-platform";
import { getLocale } from "../locale";
import { landingPageIntentsAreEquivalent, } from "./platform-landing-page-utils";
import { iPadTodayPageController, iPadAppsController, iPadArcadeController, iPadGamesController, iPadSearchLandingController, iPhoneTodayPageController, iPhoneAppsController, iPhoneGamesController, iPhoneArcadeController, iPhoneSearchLandingController, MacDiscoverController, MacArcadeController, MacCreateController, MacWorkController, MacPlayController, MacDevelopController, MacCategoriesController, MacSearchLandingController, TVAppsController, TVArcadeController, TVDiscoverController, TVGamesController, TVSearchLandingController, VisionAppsAndGamesController, VisionArcadeController, VisionSearchLandingController, WatchDiscoverController, WatchSearchLandingController, } from "./platform-landing-page-intent-controllers";
const ARCADE_CONTROLLERS = new Set([
    iPadArcadeController,
    iPhoneArcadeController,
    MacArcadeController,
    TVArcadeController,
    VisionArcadeController,
]);
export function createLandingPageLinks(objectGraph, platform, intent) {
    if (!platform || !isPreviewPlatform(platform)) {
        return [];
    }
    // NOTE: this map cannot be defined at the module level, for risk of creating
    // a circular dependency between module-level declarations that will break the build
    // tools used by the "web" client
    const landingPageControllers = {
        ipad: [
            iPadTodayPageController,
            iPadGamesController,
            iPadAppsController,
            iPadArcadeController,
            iPadSearchLandingController,
        ],
        iphone: [
            iPhoneTodayPageController,
            iPhoneGamesController,
            iPhoneAppsController,
            iPhoneArcadeController,
            iPhoneSearchLandingController,
        ],
        mac: [
            MacDiscoverController,
            MacArcadeController,
            MacCreateController,
            MacWorkController,
            MacPlayController,
            MacDevelopController,
            MacCategoriesController,
            MacSearchLandingController,
        ],
        tv: [TVDiscoverController, TVGamesController, TVAppsController, TVArcadeController, TVSearchLandingController],
        vision: [VisionAppsAndGamesController, VisionArcadeController, VisionSearchLandingController],
        watch: [WatchDiscoverController, WatchSearchLandingController],
    };
    const locale = getLocale(objectGraph);
    const isArcadeEnabled = objectGraph.bag.isArcadeEnabled;
    return landingPageControllers[platform]
        .filter((landingPageController) => {
        // Rejects Arcade controllers if not supported and let's all other controllers pass
        const isArcadeController = ARCADE_CONTROLLERS.has(landingPageController);
        return isArcadeEnabled || !isArcadeController;
    })
        .map((controller) => controller.buildAction(locale, objectGraph))
        .map((action) => ({
        action,
        isActive: landingPageIntentsAreEquivalent(intent, action.destination),
    }));
}
//# sourceMappingURL=landing-page-links-by-platform.js.map