import { isSystemImage } from "../../api/models";
import { asString } from "../../foundation/json-parsing/server-data";
import { createArtworkForSystemImage } from "../content/artwork/artwork";
import * as metricsHelpersClicks from "../metrics/helpers/clicks";
import * as metricsHelpersLocation from "../metrics/helpers/location";
/**
 * Creates a {@linkcode PrepareAction} that sets the link's text and icon
 */
function createWebNavigationFlowActionConfiguration(id) {
    return (objectGraph, action) => {
        const tab = objectGraph.bag.tabsStandard.find((t) => t.id === id);
        const imageIdentifier = asString(tab, "image-identifier");
        const artwork = isSystemImage(imageIdentifier)
            ? createArtworkForSystemImage(objectGraph, imageIdentifier)
            : null;
        action.title = asString(tab, "title");
        action.artwork = artwork;
        if (objectGraph.client.isWeb) {
            metricsHelpersClicks.addClickEventToAction(objectGraph, action, {
                targetType: "link",
                id: id,
                pageInformation: undefined,
                locationTracker: metricsHelpersLocation.newLocationTracker(),
            });
        }
    };
}
/**
 * {@linkcode PrepareAction} that presents a link to the "Apps" landing page
 */
export const appLandingPageFlowActionPresentation = createWebNavigationFlowActionConfiguration("apps");
/**
 * {@linkcode PrepareAction} that presents a link to the "Apps & Games" landing page
 */
export const appAndGamesLandingPageFlowActionPresentation = createWebNavigationFlowActionConfiguration("apps-and-games");
/**
 * {@linkcode PrepareAction} that presents a link to the "Arcade" landing page
 */
export const arcadeLandingPageFlowActionPresentation = createWebNavigationFlowActionConfiguration("arcade");
/**
 * {@linkcode PrepareAction} that presents a link to the "Discover" landing page
 */
export const discoverLandingPageFlowActionPresentation = createWebNavigationFlowActionConfiguration("discover");
/**
 * {@linkcode PrepareAction} that presents a link to the "Games" landing page
 */
export const gamesLandingPageFlowActionPresentation = createWebNavigationFlowActionConfiguration("games");
/**
 * {@linkcode PrepareAction} that presents a link to the "Create" landing page
 *
 * Note: `create` refers to the specific "Create" landing page, rather than this being
 * a function that creates landing page presentations
 */
export const createLandingPageFlowActionPresentation = createWebNavigationFlowActionConfiguration("create");
/**
 * {@linkcode PrepareAction} that presents a link to the "Work" landing page
 */
export const workLandingPageFlowActionPresentation = createWebNavigationFlowActionConfiguration("work");
/**
 * {@linkcode PrepareAction} that presents a link to the "Play" landing page
 */
export const playLandingPageFlowActionPresentation = createWebNavigationFlowActionConfiguration("play");
/**
 * {@linkcode PrepareAction} that presents a link to the "Develop" landing page
 */
export const developLandingPageFlowActionPresentation = createWebNavigationFlowActionConfiguration("develop");
/**
 * {@linkcode PrepareAction} that presents a link to the "Categories" landing page
 */
export const categoriesLandingPageFlowActionPresentation = createWebNavigationFlowActionConfiguration("categories");
/**
 * {@linkcode PrepareAction} that presents a link to the "Today" landing page
 */
export const todayLandingPageFlowActionPresentation = createWebNavigationFlowActionConfiguration("today");
/**
 * {@linkcode PrepareAction} that presents a link to the "Apps & Games" landing page
 */
export const searchLandingPageFlowActionPresentation = createWebNavigationFlowActionConfiguration("search");
//# sourceMappingURL=flow-action-presentation.js.map