import { isNothing } from "@jet/environment";
/**
 * @param objectGraph The object graph for our dependencies
 * @returns Whether we should fetch app tags
 */
export function areAppTagsEnabled(objectGraph, featureSurface) {
    const isClientFeatureFlagEnabled = objectGraph.client.isPhone && objectGraph.featureFlags.isEnabled("app_genome_2025A");
    if (!isClientFeatureFlagEnabled) {
        return false;
    }
    if (isNothing(featureSurface)) {
        return true;
    }
    switch (featureSurface) {
        case "grouping":
            return objectGraph.bag.isAppsGroupingTagsEnabled;
        case "product":
            return objectGraph.bag.isAppsProductPageTagsEnabled;
        case "slp":
            return objectGraph.bag.isAppsSlpTagsEnabled;
        default:
            return false;
    }
}
//# sourceMappingURL=app-tags-util.js.map