import { makeRoutableArticlePageIntent, } from "../../api/intents/routable-article-page-intent";
import { generateRoutes } from "../util/generate-routes";
const { routes: routableArticlePageWithPlatformRoutes, makeCanonicalUrl: makeRoutableArticlePageWithPlatformUrl } = generateRoutes(makeRoutableArticlePageIntent, "/{platform}/story/{id}");
const { routes: routableArticlePageWithoutPlatformRoutes, makeCanonicalUrl: makeRoutableArticlePageWithoutPlatformUrl, } = generateRoutes(makeRoutableArticlePageIntent, "/story/{id}");
export { routableArticlePageWithPlatformRoutes, routableArticlePageWithoutPlatformRoutes };
/**
 * Generate the URL for an "Article Page" based on the {@linkcode intent}
 *
 * If the {@linkcode intent} has an explicitly-configured `platform` property,
 * then the resulting URL will include the explicitly as the `{platform}` prefix
 * segment. If the `platform` property is not provided, the resulting URL will
 * not contain an explicit `{platform}` segment at all.
 *
 * @param objectGraph
 * @param intent
 * @returns the URL that, when parsed, produces the given `intent`
 */
export function makeRoutableArticlePageCanonicalUrl(objectGraph, intent) {
    const intentWithExpectedID = {
        ...intent,
        // The `{id}` segment of the URL is expected to include the `id` prefix, which is removed
        // when parsing the incoming URL into the `Intent`
        id: `id${intent.id}`,
    };
    if (intent.platform) {
        return makeRoutableArticlePageWithPlatformUrl(objectGraph, intentWithExpectedID);
    }
    else {
        return makeRoutableArticlePageWithoutPlatformUrl(objectGraph, intentWithExpectedID);
    }
}
//# sourceMappingURL=routable-article-page-url-utils.js.map