import { ArtworkContentMode, EdgeInsetsZero, } from "../../../../api/models";
const storeFrontVideoLayout = {
    collapsedContentMode: ArtworkContentMode.center,
    collapsedLayoutInsets: EdgeInsetsZero,
    expandedContentMode: ArtworkContentMode.center,
    expandedLayoutInsets: EdgeInsetsZero,
};
const storeFrontVideoMetrics = {
    ltr: storeFrontVideoLayout,
    rtl: storeFrontVideoLayout,
    collapsedSize: { type: "fractionalHeight", height: 1.0 },
    expandedSize: { type: "fractionalHeight", height: 1.0 },
};
/**
 * This configuration is in 16x9 aspect ratio.
 */
export const storeFrontVideo = {
    objectPath: "editorialVideo.storeFrontVideo",
    cardArtLayoutMetrics: [storeFrontVideoMetrics],
    crops: [],
    sourceWidth: 875,
    sourceHeight: 492,
    type: "video",
};
//# sourceMappingURL=store-front-video.js.map