import { ArtworkContentMode, EdgeInsetsZero, TodayCardArtworkSizedLayoutMetricsPriority, } from "../../../../api/models";
const mediaCardLayout_mini = {
    collapsedContentMode: ArtworkContentMode.bottomLeft,
    collapsedLayoutInsets: {
        top: 0,
        left: -8,
        bottom: 0,
        right: 0,
    },
    expandedContentMode: ArtworkContentMode.bottomLeft,
    expandedLayoutInsets: EdgeInsetsZero,
};
const mediaCardLayout_base = {
    collapsedContentMode: ArtworkContentMode.bottomLeft,
    collapsedLayoutInsets: EdgeInsetsZero,
    expandedContentMode: ArtworkContentMode.bottomLeft,
    expandedLayoutInsets: EdgeInsetsZero,
};
const mediaCardLayout_700w = {
    collapsedContentMode: ArtworkContentMode.scaleAspectFill,
    expandedContentMode: ArtworkContentMode.bottomLeft,
    collapsedLayoutInsets: EdgeInsetsZero,
    expandedLayoutInsets: EdgeInsetsZero,
};
const mediaCardMetrics_mini = {
    maxWidth: 250,
    ltr: mediaCardLayout_mini,
    rtl: mediaCardLayout_mini,
    collapsedSize: { type: "fractionalHeight", height: 1.0 },
    priority: TodayCardArtworkSizedLayoutMetricsPriority.Mini,
};
const mediaCardMetrics_base = {
    maxWidth: 704,
    ltr: mediaCardLayout_base,
    rtl: mediaCardLayout_base,
    collapsedSize: { type: "fractionalHeight", height: 1.062 },
};
const mediaCardMetrics_700w = {
    ltr: mediaCardLayout_700w,
    rtl: mediaCardLayout_700w,
    collapsedSize: { type: "fractionalWidth", width: 1.0 },
};
export const mediaCard = {
    objectPath: "editorialArtwork.mediaCard",
    cardArtLayoutMetrics: [mediaCardMetrics_mini, mediaCardMetrics_base, mediaCardMetrics_700w],
    crops: ["MC.ApSCFB01"],
    sourceWidth: 800,
    sourceHeight: 490,
    type: "image",
};
//# sourceMappingURL=media-card.js.map