import { ArtworkContentMode, EdgeInsetsZero, TodayCardArtworkSizedLayoutMetricsPriority, } from "../../../../api/models";
const generalCardLayout_mini = {
    collapsedContentMode: ArtworkContentMode.bottomLeft,
    expandedContentMode: ArtworkContentMode.bottomLeft,
    collapsedLayoutInsets: {
        top: 0,
        left: -8,
        bottom: 0,
        right: 0,
    },
    expandedLayoutInsets: EdgeInsetsZero,
};
const generalCardLayout_base = {
    collapsedContentMode: ArtworkContentMode.bottomLeft,
    expandedContentMode: ArtworkContentMode.bottomLeft,
    collapsedLayoutInsets: EdgeInsetsZero,
    expandedLayoutInsets: EdgeInsetsZero,
};
const generalCardLayout_700w = {
    collapsedContentMode: ArtworkContentMode.scaleAspectFill,
    expandedContentMode: ArtworkContentMode.bottomLeft,
    collapsedLayoutInsets: EdgeInsetsZero,
    expandedLayoutInsets: EdgeInsetsZero,
};
const generalCardMetrics_mini = {
    maxWidth: 250,
    ltr: generalCardLayout_mini,
    rtl: generalCardLayout_mini,
    collapsedSize: { type: "fractionalHeight", height: 1.0 },
    priority: TodayCardArtworkSizedLayoutMetricsPriority.Mini,
};
const generalCardMetrics_base = {
    maxWidth: 704,
    ltr: generalCardLayout_base,
    rtl: generalCardLayout_base,
    collapsedSize: { type: "fractionalHeight", height: 1.062 },
};
const generalCardMetrics_700w = {
    ltr: generalCardLayout_700w,
    rtl: generalCardLayout_700w,
    collapsedSize: { type: "fractionalWidth", width: 1.0 },
};
export const generalCard = {
    objectPath: "editorialArtwork.generalCard",
    cardArtLayoutMetrics: [generalCardMetrics_mini, generalCardMetrics_base, generalCardMetrics_700w],
    crops: ["MC.ApSCFB01"],
    sourceWidth: 800,
    sourceHeight: 490,
    type: "image",
};
//# sourceMappingURL=general-card.js.map