import { ArtworkContentMode, EdgeInsetsZero, TodayCardArtworkSizedLayoutMetricsPriority, } from "../../../../api/models";
const dayCardLayout_mini = {
    collapsedContentMode: ArtworkContentMode.bottomLeft,
    expandedContentMode: ArtworkContentMode.bottomLeft,
    collapsedLayoutInsets: {
        top: 0,
        left: -8,
        bottom: 0,
        right: 0,
    },
    expandedLayoutInsets: EdgeInsetsZero,
};
const dayCardLayout_base = {
    collapsedContentMode: ArtworkContentMode.bottomLeft,
    expandedContentMode: ArtworkContentMode.bottomLeft,
    collapsedLayoutInsets: EdgeInsetsZero,
    expandedLayoutInsets: EdgeInsetsZero,
};
const dayCardLayout_700w = {
    collapsedContentMode: ArtworkContentMode.topLeft,
    expandedContentMode: ArtworkContentMode.bottomLeft,
    collapsedLayoutInsets: EdgeInsetsZero,
    expandedLayoutInsets: EdgeInsetsZero,
};
const dayCardMetrics_mini = {
    maxWidth: 250,
    ltr: dayCardLayout_mini,
    rtl: dayCardLayout_mini,
    collapsedSize: { type: "fractionalHeight", height: 1.0 },
    priority: TodayCardArtworkSizedLayoutMetricsPriority.Mini,
};
const dayCardMetrics_base = {
    maxWidth: 704,
    ltr: dayCardLayout_base,
    rtl: dayCardLayout_base,
    collapsedSize: { type: "fractionalHeight", height: 1.062 },
};
const dayCardMetrics_700w = {
    ltr: dayCardLayout_700w,
    rtl: dayCardLayout_700w,
    collapsedSize: { type: "fractionalWidth", width: 1.0 },
};
export const dayCard = {
    objectPath: "editorialArtwork.dayCard",
    cardArtLayoutMetrics: [dayCardMetrics_mini, dayCardMetrics_base, dayCardMetrics_700w],
    crops: ["sr"],
    sourceWidth: 800,
    sourceHeight: 490,
    type: "image",
};
//# sourceMappingURL=day-card.js.map