import { defaultAdditionalPlatformsForClient, Request } from "../../foundation/media/data-fetching";
import { shouldFetchCustomAttributes } from "../product-page/product-page-variants";
import { appEventsAreEnabled, appOfferItemsAreEnabled } from "../app-promotions/app-promotions-common";
import { shouldUsePrerenderedIconArtwork } from "../content/content";
import { AppEventsAttributes } from "../../gameservicesui/src/foundation/media-api/requests/recommendation-request-types";
function buildAttributesForArticlePageRequest(objectGraph) {
    const attributes = [
        "screenshotsByType",
        "videoPreviewsByType",
        "requiredCapabilities",
        "minimumOSVersion",
        "editorialArtwork",
        "editorialVideo",
        "editorialClientParams",
        "shortEditorialNotes",
        "enrichedEditorialNotes",
    ];
    if (objectGraph.bag.enableUpdatedAgeRatings) {
        attributes.push("ageRating");
    }
    if (objectGraph.appleSilicon.isSupportEnabled) {
        attributes.push("macRequiredCapabilities");
    }
    if (objectGraph.client.isMac) {
        attributes.push("hasMacIPAPackage");
    }
    if (objectGraph.client.isVision) {
        attributes.push("compatibilityControllerRequirement");
    }
    if (shouldUsePrerenderedIconArtwork(objectGraph)) {
        attributes.push("iconArtwork");
    }
    return attributes;
}
/**
 * Create a Media API request for an `editorial-item`
 *
 * This corresponsd to an "Article" or "Story" page
 */
export function buildArticlePageRequest(objectGraph, intent, isIncomingURL) {
    const request = new Request(objectGraph)
        .withIdOfType(intent.id, "editorial-items")
        .includingAdditionalPlatforms(defaultAdditionalPlatformsForClient(objectGraph))
        .includingAttributes(buildAttributesForArticlePageRequest(objectGraph))
        .includingRelationships(["canvas"])
        .includingRelationshipsForUpsell(true)
        .includingMacOSCompatibleIOSAppsWhenSupported(true)
        .usingCustomAttributes(shouldFetchCustomAttributes(objectGraph));
    if (!isIncomingURL) {
        request.includingAgeRestrictions();
    }
    if (appEventsAreEnabled(objectGraph)) {
        request.enablingFeature("appEvents");
        request.includingScopedAttributes("app-events", AppEventsAttributes);
        request.includingScopedRelationships("app-events", ["app"]);
        request.includingScopedRelationships("editorial-item-shelves", ["app-events"]);
        request.includingScopedAvailableIn("app-events", ["past"]);
    }
    if (appOfferItemsAreEnabled(objectGraph)) {
        request.enablingFeature("offerItems");
        request.includingScopedRelationships("offer-items", ["salables"]);
        request.includingAssociateKeys("editorial-items", ["editorial-cards"]);
        request.includingMetaKeys("offer-items:salables", ["discountOffer"]);
        request.includingScopedAttributes("offer-items", [
            "title",
            "subtitle",
            "additionalTerms",
            "redemptionExpirationDate",
        ]);
    }
    if (objectGraph.client.isVision) {
        request.enablingFeature("supportsCustomTextColor");
        request.includingScopedAttributes("editorial-items", ["enrichedEditorialNotes"]);
    }
    if (objectGraph.client.isWeb) {
        request.includingAttributes([
            // Publication date is used as part of SEO meta-data
            "lastPublishedDate",
        ]);
    }
    if (preprocessor.GAMES_TARGET) {
        request.includingScopedAttributes("apps", ["isEligibleForGamesApp"]);
    }
    return request;
}
//# sourceMappingURL=article-request.js.map