/**
 * Build methods for Search Transparency.
 * Search transparency provides additional disclosure message about search ranking required in certain storefronts.
 */
import { isNothing } from "@jet/environment";
import { FlowAction, LinkableText, StyledText } from "../../api/models";
import { addClickEventToAction } from "../metrics/helpers/clicks";
import { makeRoutableArticlePageCanonicalUrl } from "../today/routable-article-page-url-utils";
import { makeRoutableArticlePageIntent } from "../../api/intents/routable-article-page-intent";
import { getPlatform } from "../preview-platform";
import { getLocale } from "../locale";
export function createSearchResultsLearnMoreNoticeLinkableText(objectGraph, metricsOptions) {
    const editorialItemId = objectGraph.bag.searchResultsLearnMoreEditorialId;
    if (isNothing(editorialItemId) || (editorialItemId === null || editorialItemId === void 0 ? void 0 : editorialItemId.length) === 0) {
        return undefined;
    }
    const clickOptions = {
        kind: "editorialItem",
        softwareType: null,
        title: objectGraph.loc.string("SEARCH_TRANSPARENCY_LINK"),
        id: editorialItemId,
        targetType: "link",
        pageInformation: metricsOptions.pageInformation,
        locationTracker: metricsOptions.locationTracker,
    };
    const text = objectGraph.loc.string("SEARCH_TRANSPARENCY_TEXT");
    const learnMoreAction = new FlowAction("article");
    learnMoreAction.title = text;
    learnMoreAction.pageUrl = `https://apps.apple.com/story/id${editorialItemId}`;
    if (objectGraph.client.isWeb) {
        const destination = makeRoutableArticlePageIntent({
            ...getLocale(objectGraph),
            ...getPlatform(objectGraph),
            id: editorialItemId,
        });
        const pageUrlString = makeRoutableArticlePageCanonicalUrl(objectGraph, destination);
        learnMoreAction.pageUrl = pageUrlString;
        learnMoreAction.destination = destination;
    }
    addClickEventToAction(objectGraph, learnMoreAction, clickOptions);
    const linkSubstrings = {};
    linkSubstrings[`${objectGraph.loc.string("SEARCH_TRANSPARENCY_LINK")}`] = learnMoreAction;
    const styledText = new StyledText(text, "text/plain");
    return new LinkableText(styledText, linkSubstrings);
}
//# sourceMappingURL=search-results-learn-more-notice.js.map