import { MetadataRibbonItem } from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import { contentAttributeAsBooleanOrFalse } from "../../content/attributes";
import * as metricsHelpersImpressions from "../../metrics/helpers/impressions";
export function createMetadataRibbonItems(objectGraph, data, lockup, dedupeSet, metricsOptions) {
    const isPreorder = contentAttributeAsBooleanOrFalse(objectGraph, data, "isPreorder");
    if (serverData.isDefinedNonNull(lockup.ratingCount) && serverData.isDefinedNonNull(lockup.rating) && !isPreorder) {
        const starRatingItem = new MetadataRibbonItem("starRating");
        starRatingItem.moduleType = "userRating";
        starRatingItem.starRating = lockup.rating;
        starRatingItem.labelText = lockup.ratingCount;
        const impressionOptions = metricsHelpersImpressions.impressionOptionsForMetadataRibbonItem(metricsOptions, "userRating", "User Rating", "static");
        metricsHelpersImpressions.addImpressionFieldsToSearchMetadataRibbonItem(objectGraph, starRatingItem, impressionOptions);
        return [starRatingItem];
    }
    else {
        return null;
    }
}
//# sourceMappingURL=star-rating-metadata-ribbon-item.js.map