import { isNothing, isSome } from "@jet/environment";
import { MetadataRibbonItem } from "../../../api/models";
import { attributeAsString } from "../../../foundation/media/attributes";
import { categoryArtworkData } from "../../categories";
import { artworkFromApiArtwork } from "../../content/content";
import * as metricsHelpersImpressions from "../../metrics/helpers/impressions";
export function createMetadataRibbonItems(objectGraph, data, lockup, dedupeSet, metricsOptions) {
    const artworkData = categoryArtworkData(objectGraph, data, true);
    const hasArtwork = isSome(artworkData);
    const shortGenre = attributeAsString(data, "genreShortDisplayName");
    if (shortGenre != null) {
        if (dedupeSet.has(shortGenre)) {
            return null;
        }
        else {
            dedupeSet.add(shortGenre);
        }
    }
    if (isNothing(shortGenre) || shortGenre.length === 0) {
        return null;
    }
    const viewType = hasArtwork ? "imageWithLabel" : "textLabel";
    const shortCategoryItem = new MetadataRibbonItem(viewType);
    shortCategoryItem.moduleType = "genreShortDisplayName";
    shortCategoryItem.labelText = shortGenre;
    if (hasArtwork) {
        shortCategoryItem.artwork = artworkFromApiArtwork(objectGraph, artworkData, {
            useCase: 20 /* ArtworkUseCase.CategoryIcon */,
            cropCode: "sr",
        });
    }
    const impressionOptions = metricsHelpersImpressions.impressionOptionsForMetadataRibbonItem(metricsOptions, "genreDisplayName", shortCategoryItem.labelText, "static");
    metricsHelpersImpressions.addImpressionFieldsToSearchMetadataRibbonItem(objectGraph, shortCategoryItem, impressionOptions);
    return [shortCategoryItem];
}
//# sourceMappingURL=short-category-metadata-ribbon-item.js.map