import { isSome } from "@jet/environment/types/optional";
import * as models from "../../../api/models";
import * as contentArtwork from "../../content/artwork/artwork";
import * as contentAttributes from "../../content/attributes";
import * as metricsHelpersImpressions from "../../metrics/helpers/impressions";
export function createMetadataRibbonItems(objectGraph, data, lockup, dedupeSet, metricsOptions) {
    var _a;
    let isGameControllerSupported = false;
    switch (contentAttributes.contentAttributeAsString(objectGraph, data, "remoteControllerRequirement")) {
        case "CONTROLLER_REQUIRED":
        case "CONTROLLER_OPTIONAL":
            isGameControllerSupported = true;
            break;
        default:
            break;
    }
    if (contentAttributes.contentAttributeAsBooleanOrFalse(objectGraph, data, "supportsGameController")) {
        isGameControllerSupported = true;
    }
    if (!isGameControllerSupported) {
        return null;
    }
    const gameControllerItem = new models.MetadataRibbonItem("imageWithLabel");
    gameControllerItem.moduleType = "supportsGameController";
    // Only use an ad override locale if this is an ad.
    const useAdsLocale = (isSome(lockup.searchAd) || isSome((_a = lockup.searchAdOpportunity) === null || _a === void 0 ? void 0 : _a.searchAd)) &&
        isSome(objectGraph.bag.adsOverrideLanguage);
    gameControllerItem.labelText = useAdsLocale
        ? objectGraph.adsLoc.string("BADGE_MFI_SUPPORTED")
        : objectGraph.loc.string("BADGE_MFI_SUPPORTED");
    gameControllerItem.artwork = contentArtwork.createArtworkForResource(objectGraph, "systemimage://gamecontroller.fill");
    const impressionOptions = metricsHelpersImpressions.impressionOptionsForMetadataRibbonItem(metricsOptions, "supportsGameController", "Supports Game Controller", "static");
    metricsHelpersImpressions.addImpressionFieldsToSearchMetadataRibbonItem(objectGraph, gameControllerItem, impressionOptions);
    return [gameControllerItem];
}
//# sourceMappingURL=game-controller-metadata-ribbon-item.js.map